/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.cubedata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.olap.Aggregator;
import kd.bos.algo.olap.Cell;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapConfig;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.cubedata.CubeData;
import kd.bos.algo.olap.cubedata.CubeDataReader;
import kd.bos.algo.olap.cubedata.DisableAggTester;
import kd.bos.algo.olap.impl.BBFilterIndexes;
import kd.bos.algo.olap.impl.Coordy;
import kd.bos.algo.olap.impl.CubeEvaluateContext;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.EvaluatorImpl;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.MetadataAPIImpl;
import kd.bos.algo.olap.impl.Stats;
import kd.bos.algo.olap.impl.WeightCalculation;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.MdxQuery;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.util.BitSetFactory;
import kd.bos.algo.olap.util.LongBitSet;
import org.apache.log4j.Logger;

public class MemCubeData3
extends CubeData
implements CubeDataReader {
    private static final Logger logger = Logger.getLogger(MemCubeData3.class);
    HashMap<PointWithMembers, Object> detailCubeData = new HashMap();
    HashMap<PointWithMembers, Object> selfData = new HashMap();
    HashMap<PointWithMembers, Object> selfDataRollup = new HashMap();
    HashMap<PointWithMembers, Object> detailCubeCache = new HashMap();
    private OlapConfig config;
    private BBFilterIndexes bbFilterCube;
    private BBFilterIndexes bbFilterCalc;
    private final Coordy coordy;
    private WeightCalculation wc;
    private DisableAggTester disableAggTester;
    private LongBitSet nullBitSet = BitSetFactory.createLongBitSet();
    private int calcDimensionIndex = -1;

    public MemCubeData3(Cube _cube, OlapConfig config) throws OlapException {
        super(_cube);
        this.config = config;
        this.measures = this.cube.getMeasures();
        this.aggs = new Aggregator[this.measures.length];
        for (int i = 0; i < this.aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            this.aggs[i] = Aggregator.getAggregator(aggName);
        }
        this.bbFilterCube = new BBFilterIndexes(_cube);
        this.coordy = new Coordy(this.cube.getDimensions(true));
        this.wc = new WeightCalculation(_cube);
        if (!this.wc.hasWeight()) {
            this.wc = null;
        }
        this.disableAggTester = DisableAggTester.get(this.cube);
    }

    @Override
    public void addRecord(Member[] members, Object[] values) throws OlapException {
        boolean isLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            isLeaf = false;
            break;
        }
        if (!(isLeaf || this.config.supportSelfData || this.config.useSelfData)) {
            return;
        }
        if (isLeaf) {
            PointWithMembers p = new PointWithMembers(members, false);
            Object[] vs = (Object[])this.detailCubeData.get(p);
            vs = this.appendValue(vs, values);
            this.detailCubeData.put(p, vs);
            this.buildBB(this.bbFilterCube, members);
        } else {
            PointWithMembers p = new PointWithMembers(members, true);
            Object[] vs = (Object[])this.selfData.get(p);
            vs = this.appendValue(vs, values);
            this.selfData.put(p, vs);
        }
    }

    public void buildBB(Member[] members) {
        this.buildBB(this.bbFilterCube, members);
    }

    private void buildBB(BBFilterIndexes bbFilter, Member[] members) {
        if (bbFilter.inAll(members)) {
            return;
        }
        bbFilter.add(members);
        Member[] members2 = null;
        for (int i = 0; i < members.length; ++i) {
            Member parent = members[i].getParentMember();
            if (parent == null) continue;
            members2 = new Member[members.length];
            System.arraycopy(members, 0, members2, 0, members.length);
            members2[i] = parent;
            this.buildBB(bbFilter, members2);
        }
    }

    @Override
    public Object getByEvaluator(Evaluator evaluator) {
        if (this.calcDimensionIndex < 0) {
            return this.getByCube((EvaluatorImpl)evaluator, evaluator.getCurrentMembers(), evaluator.getCurrentMeasure());
        }
        return this._getByEvaluator((EvaluatorImpl)evaluator, evaluator.getCurrentMembers(), evaluator.getCurrentMeasure());
    }

    private Object getByCube(EvaluatorImpl evaluator, Member[] currentMembers, Member currentMeasure) {
        if (this.disableAggTester != null && this.disableAggTester.test(currentMembers)) {
            return null;
        }
        PointWithMembers point = new PointWithMembers(currentMembers, false);
        Object[] values = this._getDataInCube(currentMembers, point);
        return values == null ? null : this.fetchMeasureObject(values, currentMeasure);
    }

    private Object _getByEvaluator(Evaluator evaluator, Member[] members, Member measure) {
        MemberImpl[] children;
        boolean bbFilterCalcTest;
        boolean allLeaf = true;
        boolean hasDisableAgg = false;
        if (this.disableAggTester != null && this.disableAggTester.test(evaluator.getCurrentMembers())) {
            hasDisableAgg = true;
        }
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isLeaf()) continue;
            allLeaf = false;
        }
        Calc calc = ((MemberImpl)members[this.calcDimensionIndex]).getCalc(members, (EvaluatorImpl)evaluator, !hasDisableAgg, allLeaf);
        if (calc != null) {
            return calc.evaluate(evaluator.push());
        }
        if (hasDisableAgg) {
            return null;
        }
        Object[] values = null;
        PointWithMembers point = new PointWithMembers(members, false);
        if (allLeaf) {
            values = (Object[])this.detailCubeData.get(point);
            if (values != null) {
                return this.fetchMeasureObject(values, measure);
            }
            return null;
        }
        if (this.nullBitSet.get(point.coordinate)) {
            return null;
        }
        values = (Object[])this.detailCubeCache.get(point);
        if (values != null) {
            return this.fetchMeasureObject(values, measure);
        }
        boolean bl = bbFilterCalcTest = this.bbFilterCalc != null && this.bbFilterCalc.inOne(members);
        if (!bbFilterCalcTest) {
            values = this.aggInCube(members, point);
            if (values != null) {
                return this.fetchMeasureObject(values, measure);
            }
            return null;
        }
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        boolean processed = false;
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children2;
            if (this.calcDimensionIndex == i || (children2 = ((MemberImpl)members[i]).getChildren()) == null || children2.length <= 0) continue;
            for (int j = 0; j < children2.length; ++j) {
                ms[i] = children2[j];
                Object[] vs = null;
                if (!ms[i].hasData() && !this.bbFilterCalc.inOne(ms) || (vs = this._getByEvaluatorAllMeasure(evaluator.push(ms), ms)) == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                if (values == null) {
                    values = new Object[this.aggs.length];
                }
                for (int k = 0; k < this.measures.length; ++k) {
                    if (this.aggs[k] == null) continue;
                    values[k] = this.aggs[k].appendAggregator(values[k], vs[k]);
                }
            }
            processed = true;
            break;
        }
        if (!processed && members[this.calcDimensionIndex].isDesendantHasExpression() && (children = ((MemberImpl)members[this.calcDimensionIndex]).getChildren()) != null && children.length > 0) {
            for (int j = 0; j < children.length; ++j) {
                ms[this.calcDimensionIndex] = children[j];
                Object[] vs = null;
                if (!ms[this.calcDimensionIndex].hasData() && !this.bbFilterCalc.inOne(ms) || (vs = this._getByEvaluatorAllMeasure(evaluator.push(ms), ms)) == null || (vs = this.calcWeight(ms, vs, this.calcDimensionIndex)) == null) continue;
                if (values == null) {
                    values = new Object[this.aggs.length];
                }
                for (int k = 0; k < this.measures.length; ++k) {
                    if (this.aggs[k] == null) continue;
                    values[k] = this.aggs[k].appendAggregator(values[k], vs[k]);
                }
            }
        }
        if (values == null) {
            this.nullBitSet.set(point.coordinate);
            return null;
        }
        this.detailCubeCache.put(point, values);
        return this.fetchMeasureObject(values, measure);
    }

    private Object[] _getDataInCube(Member[] members) throws OlapException {
        PointWithMembers point = new PointWithMembers(members, false);
        Object[] values = this._getDataInCube(members, point);
        return values;
    }

    private Object[] _getDataInCube(Member[] members, PointWithMembers point) throws OlapException {
        boolean allLeaf = true;
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].hasData()) {
                return null;
            }
            if (members[i].isLeaf()) continue;
            allLeaf = false;
        }
        if (!this.bbFilterCube.inAll(members)) {
            return null;
        }
        Object[] values = null;
        if (allLeaf) {
            return (Object[])this.detailCubeData.get(point);
        }
        if (this.nullBitSet.get(point.coordinate)) {
            return null;
        }
        values = (Object[])this.detailCubeCache.get(point);
        if (values != null) {
            return values;
        }
        return this.aggInCube(members, point);
    }

    private Object[] aggInCube(Member[] members, PointWithMembers point) throws OlapException {
        Object[] values = null;
        Member[] ms = new Member[members.length];
        System.arraycopy(members, 0, ms, 0, ms.length);
        for (int i = 0; i < members.length; ++i) {
            MemberImpl[] children = ((MemberImpl)members[i]).getChildren();
            if (children == null || children.length <= 0) continue;
            for (int j = 0; j < children.length; ++j) {
                Object[] vs;
                ms[i] = children[j];
                if (!ms[i].hasData() || (vs = this._getDataInCube(ms)) == null || (vs = this.calcWeight(ms, vs, i)) == null) continue;
                if (values == null) {
                    values = new Object[this.aggs.length];
                }
                for (int k = 0; k < this.measures.length; ++k) {
                    if (this.aggs[k] == null) continue;
                    values[k] = this.aggs[k].appendAggregator(values[k], vs[k]);
                }
            }
            break;
        }
        if (values == null) {
            this.nullBitSet.set(point.coordinate);
            return null;
        }
        this.detailCubeCache.put(point, values);
        return values;
    }

    public Object[] _getByEvaluatorAllMeasure(Evaluator evaluator, Member[] currentMembers) {
        Member[] measures = evaluator.getSchemaReader().getCube().getMeasures();
        Object[] values = new Object[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            evaluator.setContext(measures[i]);
            values[i] = this._getByEvaluator(evaluator, currentMembers, measures[i]);
        }
        return values;
    }

    private final Object fetchMeasureObject(Object[] values, Member measure) {
        return values[measure.getOrdinal()];
    }

    private Object[] calcWeight(Member[] ms, Object[] vs, int index) {
        return this.wc == null ? vs : this.wc.calc(ms, vs, index);
    }

    public Object[] appendAggregator(Object[] v1, Object[] v2) throws OlapException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            v1 = new Object[this.measures.length];
            for (int i = 0; i < this.measures.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendAggregator(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new OlapException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendAggregator(v1[i], v2[i]);
        }
        return result;
    }

    public Object[] appendValue(Object[] v1, Object[] v2) throws OlapException {
        if (v1 == null && v2 == null) {
            return null;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1 == null) {
            v1 = new Object[v2.length];
            for (int i = 0; i < v1.length; ++i) {
                v1[i] = this.aggs[i] == null ? v2[i] : this.aggs[i].appendValue(v1[i], v2[i]);
            }
            return v1;
        }
        Object[] result = new Object[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            if (this.aggs[i] == null) {
                if (v2[i] == null) continue;
                if (v1[i] != null) {
                    throw new OlapException("Measure '" + this.measures[i].getName() + "' no aggregator defined.");
                }
                result[i] = v2[i];
                continue;
            }
            result[i] = this.aggs[i].appendValue(v1[i], v2[i]);
        }
        return result;
    }

    @Override
    public void finishBuildData(Stats stats) throws OlapException {
        String message = "After finish build data:";
        logger.info((Object)message);
        this.printStatistics(stats);
    }

    @Override
    public void release() {
        this.detailCubeData.clear();
        this.selfData.clear();
        this.selfDataRollup.clear();
        this.detailCubeCache.clear();
    }

    @Override
    public void printStatistics(Stats stats) {
        String message = "All Cuba Data size:" + (this.detailCubeData.size() + this.detailCubeCache.size() + this.selfData.size() + this.selfDataRollup.size());
        this.println(message);
        stats.appendMessage(message);
        message = "    detail data size:" + this.detailCubeData.size();
        this.println(message);
        stats.appendMessage(message);
        if (this.detailCubeCache.size() > 0) {
            message = " detail rollup cache size:" + this.detailCubeCache.size();
            this.println(message);
            stats.appendMessage(message);
        }
        if (this.selfData.size() > 0) {
            message = "    --not detail data size:" + this.selfData.size();
            this.println(message);
            stats.appendMessage(message);
        }
        if (this.selfDataRollup.size() > 0) {
            message = "    --not detail data rollup size:" + this.selfDataRollup.size();
            this.println(message);
            stats.appendMessage(message);
        }
    }

    private void println(String message) {
        logger.info((Object)message);
    }

    @Override
    public void setCalcBBFilterIndexes(BBFilterIndexes bbIndexes) {
        this.bbFilterCalc = bbIndexes;
        DimensionImpl[] dims = (DimensionImpl[])this.cube.getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            if (!dims[i].hasCalcMembers()) continue;
            this.calcDimensionIndex = i;
            break;
        }
    }

    @Override
    public Iterator<Cell> cellIterator() {
        throw new OlapException("Not supported, only support with olapConfig.onlyRollupCubes=true");
    }

    @Override
    public void finishAddRecord(Stats stats) throws OlapException {
    }

    @Override
    public void afterBuild(CubeEvaluateContext evaluateContext, MetadataAPIImpl metadataAPI, MdxQuery mdxQuery, List<Map<String, Member>> allLinkMembers) {
    }

    private class PointWithMembers {
        private long coordinate;
        private int[] keys;
        private transient int h = 0;

        public PointWithMembers(Member[] members, boolean keepMembers) {
            this.keys = new int[members.length];
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i] = ((MemberImpl)members[i]).getGlobalOrder();
            }
            this.coordinate = MemCubeData3.this.coordy.getCoord(this.keys);
            if (this.coordinate <= 0L) {
                throw new OlapException("Cube coordinate exceed Long.MAX.");
            }
        }

        public int hashCode() {
            if (this.coordinate > 0L) {
                return (int)(this.coordinate ^ this.coordinate >>> 32);
            }
            if (this.h == 0) {
                this.h = Arrays.hashCode(this.keys);
            }
            return this.h;
        }

        public boolean equals(Object x) {
            if (x == null) {
                return false;
            }
            PointWithMembers p2 = (PointWithMembers)x;
            if (this.coordinate > 0L) {
                return this.coordinate == p2.coordinate;
            }
            int[] keys1 = this.keys;
            int[] keys2 = p2.keys;
            for (int i = 0; i < keys2.length; ++i) {
                if (keys1[i] == keys2[i]) continue;
                return false;
            }
            return true;
        }
    }
}

