/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.dbsource;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.dbsource.Table;

public class MemoryTable
implements Table {
    private String[] columnNames;
    private int columnCount;
    private int[] columnTypes;
    private HashMap<String, Integer> indexs;
    private ArrayList<Object[]> records;
    private int row = -1;
    private Object[] rowData = null;

    public MemoryTable(Table source) throws OlapException {
        if (source instanceof MemoryTable) {
            MemoryTable m = (MemoryTable)source;
            this.columnNames = m.columnNames;
            this.columnCount = m.columnCount;
            this.columnTypes = m.columnTypes;
            this.indexs = m.indexs;
            this.records = m.records;
        } else {
            int i;
            this.columnCount = source.getColumnCount();
            this.columnNames = source.getColumnNames();
            this.columnTypes = new int[this.columnCount];
            for (i = 0; i < this.columnCount; ++i) {
                this.columnTypes[i] = source.getColumnType(i);
            }
            this.indexs = new HashMap();
            for (i = 0; i < this.columnNames.length; ++i) {
                this.indexs.put(this.columnNames[i].toLowerCase(), source.getColumnIndex(this.columnNames[i]));
            }
            this.records = new ArrayList();
            while (source.next()) {
                this.records.add(source.getValues());
            }
        }
        source.close();
    }

    public MemoryTable copy() throws OlapException {
        return new MemoryTable(this);
    }

    @Override
    public String[] getColumnNames() throws OlapException {
        return this.columnNames;
    }

    @Override
    public int getColumnCount() throws OlapException {
        return this.columnCount;
    }

    @Override
    public int getColumnType(int index) throws OlapException {
        return this.columnTypes[index];
    }

    @Override
    public int getColumnIndex(String name) throws OlapException {
        Integer index = this.indexs.get(name.toLowerCase());
        if (index == null) {
            throw new OlapException("column '" + name + "' not found.");
        }
        return index;
    }

    @Override
    public boolean next() throws OlapException {
        ++this.row;
        if (this.row < this.records.size()) {
            this.rowData = this.records.get(this.row);
            return true;
        }
        this.rowData = null;
        return false;
    }

    @Override
    public Object getValue(int index) throws OlapException {
        return this.rowData[index];
    }

    @Override
    public Object[] getValues() throws OlapException {
        return this.rowData;
    }

    public Object[] getRowData(int row) {
        return this.records.get(row);
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.row = -1;
    }
}

