/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.dbsource;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.dbsource.Table;
import kd.bos.algo.olap.util.InOutSqlUtil;

public class ResultSetTable
implements Table {
    private final ResultSet rs;
    private ResultSetMetaData md;
    private HashMap<String, Integer> columns = new HashMap();
    private String[] columnNames;
    private Object[] data;
    private static final Null nullObject = new Null();

    public ResultSetTable(ResultSet _rs) throws SQLException {
        this.rs = _rs;
        this.md = this.rs.getMetaData();
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 1; i <= this.md.getColumnCount(); ++i) {
            String column = this.md.getColumnName(i);
            this.columns.put(column.toLowerCase(), i - 1);
            v.add(column);
        }
        this.columnNames = v.toArray(new String[v.size()]);
    }

    public ResultSetMetaData getMetaData() {
        return this.md;
    }

    public void nullData() {
        int size = this.columnNames.length;
        this.data = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = nullObject;
        }
    }

    @Override
    public String[] getColumnNames() throws OlapException {
        return this.columnNames;
    }

    @Override
    public int getColumnCount() throws OlapException {
        try {
            return this.md.getColumnCount();
        }
        catch (SQLException e) {
            throw new OlapException(e);
        }
    }

    @Override
    public int getColumnType(int index) throws OlapException {
        try {
            return this.md.getColumnType(index + 1);
        }
        catch (SQLException e) {
            throw new OlapException(e);
        }
    }

    @Override
    public int getColumnIndex(String name) throws OlapException {
        Integer index = this.columns.get(name.toLowerCase());
        if (index == null) {
            throw new OlapException("Column '" + name + "' not found.");
        }
        return index;
    }

    @Override
    public boolean next() throws OlapException {
        try {
            this.nullData();
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new OlapException(e);
        }
    }

    @Override
    public Object getValue(int index) throws OlapException {
        if (this.data[index] != nullObject) {
            return this.data[index];
        }
        try {
            this.data[index] = InOutSqlUtil.getValue(this.rs, this.getColumnType(index), index + 1);
            return this.data[index];
        }
        catch (SQLException e) {
            throw new OlapException(e);
        }
    }

    @Override
    public Object[] getValues() throws OlapException {
        for (int i = 0; i < this.data.length; ++i) {
            if (nullObject != this.data[i]) continue;
            this.data[i] = this.getValue(i);
        }
        return this.data;
    }

    @Override
    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class Null {
        private Null() {
        }
    }
}

