/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.dbsource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import kd.bos.algo.olap.OlapConfig;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.dbsource.ConnectionHelper;
import kd.bos.algo.olap.dbsource.DefTableProvider;
import kd.bos.algo.olap.dbsource.ResultSetTable;
import kd.bos.algo.olap.dbsource.SqlWithParamTableDef;
import kd.bos.algo.olap.dbsource.SqlWithParamTableSource;
import kd.bos.algo.olap.dbsource.Table;
import kd.bos.algo.olap.dbsource.TableProvider;
import kd.bos.algo.olap.dbsource.TableProviderFactory;
import kd.bos.algo.olap.dbsource.TableSource;
import kd.bos.algo.olap.def.ConnectionDef;
import kd.bos.algo.olap.def.ParameterDef;
import kd.bos.algo.olap.def.SchemaDef;
import kd.bos.algo.olap.def.TableDef;
import kd.bos.algo.olap.impl.Stats;
import kd.bos.algo.olap.util.IgnoreCaseString;
import kd.bos.algo.olap.util.SqlParamSet;
import org.apache.log4j.Logger;

public class TableManager {
    private static Logger log = Logger.getLogger(TableManager.class);
    Connection conn;
    Map tables = new ConcurrentHashMap();

    public TableManager(SchemaDef def, Map params, OlapConfig config, Stats stats) throws OlapException, SQLException {
        int i;
        if (def.parameters != null) {
            for (i = 0; i < def.parameters.length; ++i) {
                ParameterDef param = def.parameters[i];
                Object x = params.get(param.name);
                if (x == null) {
                    x = params.get(new IgnoreCaseString(param.name));
                }
                if (x == null) {
                    throw new OlapException("Parameter '" + param.name + "' has no data.");
                }
                if (!param.type.equalsIgnoreCase("Table")) continue;
                if (x instanceof Table) {
                    this.addTable(param.name, (Table)x);
                    continue;
                }
                if (x instanceof ResultSet) {
                    this.addTable(param.name, new ResultSetTable((ResultSet)x));
                    continue;
                }
                if (x instanceof String) {
                    this.addTable(param.name, (String)x);
                    continue;
                }
                if (x instanceof TableDef) {
                    this.addTable(param.name, new DefTableProvider(this, (TableDef)x));
                    continue;
                }
                if (x instanceof SqlWithParamTableDef) {
                    this.addTable(param.name, new SqlWithParamTableSource(this, (SqlWithParamTableDef)x));
                    continue;
                }
                TableProvider p = TableProviderFactory.createTableProvider(this, x);
                if (p != null) {
                    this.addTable(param.name, p);
                    continue;
                }
                throw new OlapException("Parameter '" + param.name + "'  not a legal Table. ");
            }
        }
        if (def.connection != null) {
            this.setConnection(def.connection);
        } else {
            Object conn = params.get("JdbcConnection");
            Object ds = params.get("JdbcDataSource");
            if (conn != null) {
                if (!(conn instanceof Connection)) {
                    throw new OlapException("Jdbc Connection must be java.sql.Connection");
                }
                this.setConnection((Connection)conn);
            } else if (ds != null) {
                if (!(ds instanceof DataSource)) {
                    throw new OlapException("Jdbc DataSource must be javax.sql.DataSource");
                }
                this.setConnection(((DataSource)ds).getConnection());
            }
        }
        if (def.tables != null) {
            for (i = 0; i < def.tables.length; ++i) {
                TableDef t = def.tables[i];
                this.addTable(t);
            }
        }
        if (def.dimensions != null) {
            for (i = 0; i < def.dimensions.length; ++i) {
                if (def.dimensions[i].table == null) {
                    throw new OlapException("Dimension " + def.dimensions[i].name + " no table defined.");
                }
                this.useTable(def.dimensions[i].table, def.dimensions[i].sql);
                this.getTableProvider(def.dimensions[i].table).setUseCase("dimension");
            }
        }
        for (i = 0; i < def.cubes.length; ++i) {
            this.useTable(def.cubes[i].table);
            this.getTableProvider(def.cubes[i].table).setUseCase("fact");
            if (!config.BUILD_AUTOJOINFACTSQL) continue;
            ((DefTableProvider)this.getTableProvider(def.cubes[i].table)).joinSql(def, def.cubes[i]);
        }
    }

    public void clear() {
        Object[] names = this.tables.keySet().toArray();
        for (int i = 0; i < names.length; ++i) {
            TableProvider ts = this.getTableProvider((String)names[i]);
            if (ts == null) continue;
            ts.close();
        }
        this.tables.clear();
    }

    public void setConnection(Connection cn) {
        this.conn = cn;
    }

    private void setConnection(ConnectionDef def) throws OlapException {
        if (this.conn == null) {
            this.conn = ConnectionHelper.makeConnection(def);
        }
    }

    ResultSet executeQuery(String sql) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("No database connection.");
        }
        PreparedStatement stm = this.conn.prepareStatement(sql);
        stm.setFetchSize(5000);
        return stm.executeQuery();
    }

    ResultSet executeQuery(String sql, SqlParamSet sps) throws SQLException {
        if (this.conn == null) {
            throw new SQLException("No database connection.");
        }
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ps.setFetchSize(5000);
        sps.putToStatement(ps);
        return ps.executeQuery();
    }

    private void addTable(String name, String sql) {
        this.addTable(name, new DefTableProvider(this, new TableDef(name, sql)));
    }

    private void addTable(String name, Table table) {
        this.addTable(name, new TableSource(this, table));
    }

    private void addTable(TableDef def) {
        this.addTable(def.name, new DefTableProvider(this, def));
    }

    private void addTable(String name, TableProvider source) {
        this.tables.put(name.toLowerCase(), source);
    }

    private boolean containsTable(String name) {
        return this.tables.containsKey(name);
    }

    void useTable(String name) {
        this.getTableProvider(name).addUse();
    }

    void useTable(String name, String sql) {
        this.getTableProvider(name, sql).addUse();
    }

    public void releaseTable(String name) {
        TableProvider source = this.getTableProvider(name);
        if (source == null) {
            return;
        }
        if (source.release()) {
            this.tables.remove(name);
        }
    }

    public TableProvider getTableProvider(String name) {
        TableProvider ts = (TableProvider)this.tables.get(name.toLowerCase());
        if (ts == null) {
            this.addTable(name, name);
            return (TableProvider)this.tables.get(name.toLowerCase());
        }
        return ts;
    }

    public TableProvider getTableProvider(String name, String sql) {
        TableProvider ts = (TableProvider)this.tables.get(name.toLowerCase());
        if (ts == null) {
            this.addTable(name, sql);
            return (TableProvider)this.tables.get(name.toLowerCase());
        }
        return ts;
    }

    public Table getTable(String name) throws SQLException, OlapException {
        return this.getTableProvider(name).get();
    }
}

