/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.sql.SQLException;
import java.util.Map;
import kd.bos.algo.olap.Database;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.MemberScopeBuilder;
import kd.bos.algo.olap.MetadataAPI;
import kd.bos.algo.olap.OlapConfig;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.cubedata.CubeDataFactory;
import kd.bos.algo.olap.cubedata.ICubeData;
import kd.bos.algo.olap.dbsource.Table;
import kd.bos.algo.olap.dbsource.TableManager;
import kd.bos.algo.olap.def.AbstractCubeDimensionDef;
import kd.bos.algo.olap.def.CubeDef;
import kd.bos.algo.olap.def.DimensionMembersDef;
import kd.bos.algo.olap.def.DimensionUsageDef;
import kd.bos.algo.olap.def.MemberExpressionDef;
import kd.bos.algo.olap.def.MemberScopeDef;
import kd.bos.algo.olap.def.SchemaDef;
import kd.bos.algo.olap.def.ScopedExpressionDef;
import kd.bos.algo.olap.impl.BuildContext;
import kd.bos.algo.olap.impl.CubeImpl;
import kd.bos.algo.olap.impl.DimensionBuildResult;
import kd.bos.algo.olap.impl.DimensionBuilder;
import kd.bos.algo.olap.impl.DimensionFetch;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.DimensionUsageFetch;
import kd.bos.algo.olap.impl.MeasureFetch;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.MetadataAPIImpl;
import kd.bos.algo.olap.impl.SchemaBuilder;
import kd.bos.algo.olap.impl.SchemaImpl;
import kd.bos.algo.olap.impl.SchemaReaderImpl;
import kd.bos.algo.olap.impl.Stats;
import org.apache.log4j.Logger;

public class CubeBuilder {
    private static Logger logger = Logger.getLogger(CubeBuilder.class);

    public static TableManager getTableManager(SchemaDef def, Map params, OlapConfig config, Stats stats) throws OlapException, SQLException {
        return new TableManager(def, params, config == null ? new OlapConfig() : config, stats);
    }

    public static SchemaImpl buildSchema(BuildContext buildContext, SchemaDef def, boolean checkSchemaDef, Stats stats) throws OlapException, SQLException {
        if (checkSchemaDef) {
            logger.info((Object)"checking schema define...");
            def.check();
        }
        logger.info((Object)"building schema object...");
        Stats.StatItem item = stats.createStatItem("build schema include:parseSchema,build dimensions,build addtional");
        SchemaImpl schema = SchemaBuilder.buildSchema(def);
        logger.info((Object)"schema building succeeded.");
        logger.info((Object)"preparing connection & table Manager.");
        long time = System.currentTimeMillis();
        Stats.StatItem item2 = stats.createStatItem("build dimensions");
        if (def.dimensions != null) {
            DimensionBuilder.build(buildContext, schema, def, stats);
        }
        item2.close();
        CubeBuilder.buildAddtional(schema);
        item.close();
        logger.info((Object)("build schema cost " + (System.currentTimeMillis() - time) + " ms."));
        return schema;
    }

    public static void buildAddtional(SchemaImpl schema) {
        MetadataAPIImpl api = new MetadataAPIImpl(new SchemaReaderImpl(schema, null));
        CubeBuilder.buildMemberScope((MetadataAPI)api, schema);
        CubeBuilder.buildMemberExpressions(api, schema);
    }

    private static void buildMemberScope(MetadataAPI api, SchemaImpl schema) {
        MemberScopeDef[] defs = schema.getCube().getDef().memberScopes;
        if (defs == null) {
            return;
        }
        for (MemberScopeDef def : defs) {
            CubeBuilder.buildMemberScope(api, def);
        }
    }

    private static void buildMemberScope(MetadataAPI api, MemberScopeDef def) {
        MemberScopeBuilder builder = api.getMemberScopeBuilder();
        builder.setName(def.getName());
        for (DimensionMembersDef item : def.getItems()) {
            builder.addExpression(item.getDimension(), item.getExpression());
        }
        api.addMemberSope(builder.build());
    }

    private static void buildMemberExpressions(MetadataAPI api, SchemaImpl schema) throws OlapException {
        MemberExpressionDef[] mes = schema.getCube().getDef().memberExpressions;
        if (mes == null) {
            return;
        }
        for (MemberExpressionDef me : mes) {
            CubeBuilder.buildMemberExpression(api, me);
        }
    }

    private static void buildMemberExpression(MetadataAPI api, MemberExpressionDef me) throws OlapException {
        String uniqueName = me.getUniqueName();
        if (me.getExpressionDef() != null) {
            String expression = me.getExpressionDef().getText();
            api.addDefaultMemberExpression(uniqueName, expression, me.getLeafFeature());
        } else if (me.getScopedExpressionList() != null) {
            for (ScopedExpressionDef se : me.getScopedExpressionList()) {
                api.addScopedMemberExpression(uniqueName, se.getScopeName(), se.getExpression().getText(), se.getLeafFeature());
            }
        }
    }

    public static Database buildDatabase(BuildContext buildContext, SchemaImpl schema, SchemaDef def, OlapConfig config, Stats stats) throws OlapException, SQLException {
        Database database = new Database(schema, def.cubes[0], buildContext, config, stats);
        return database;
    }

    public static ICubeData buildCubeData(MetadataAPIImpl metadataApi, BuildContext buildContext, SchemaImpl schema, CubeImpl cube, CubeDef cubeDef, OlapConfig config, Stats stats) throws OlapException, SQLException {
        long time0;
        logger.info((Object)("building cube '" + cubeDef.name + "'..."));
        ICubeData data = CubeDataFactory.createCubeData(metadataApi, cube, config, stats);
        Stats.StatItem statItem = stats.createStatItem("build cube data");
        long begin = System.currentTimeMillis();
        Table table = buildContext.getTableManager().getTable(cubeDef.table);
        long inputCost = System.currentTimeMillis() - begin;
        int dimCount = cube.dims.length;
        DimensionFetch[] cdfs = new DimensionFetch[dimCount];
        for (int i = 0; i < dimCount; ++i) {
            AbstractCubeDimensionDef cd = cubeDef.dimensions[i];
            if (!(cd instanceof DimensionUsageDef)) continue;
            DimensionImpl dim2 = (DimensionImpl)cube.getDimension(cube.dims[i].getName());
            cube.dims[i].memberCount = dim2.memberCount;
            cube.dims[i].mapOrderToMember = dim2.mapOrderToMember;
            DimensionBuildResult dbr = buildContext.getDimensionResult(cd.name);
            cdfs[i] = new DimensionUsageFetch(dbr, cube.dims[i], (DimensionUsageDef)cd, buildContext.config);
        }
        int measureCount = cube.measures.length;
        MeasureFetch[] mfs = new MeasureFetch[measureCount];
        for (int i = 0; i < measureCount; ++i) {
            mfs[i] = new MeasureFetch(cube.measures[i], cubeDef.measures[i]);
        }
        logger.info((Object)"fetching cube data...");
        int recordCount = 0;
        int errorCount = 0;
        long time = time0 = System.currentTimeMillis();
        Member[] members = new MemberImpl[dimCount];
        begin = System.currentTimeMillis();
        long nextCost = 0L;
        block2: while (true) {
            long nextBegin = System.currentTimeMillis();
            boolean hasNext = table.next();
            nextCost += System.currentTimeMillis() - nextBegin;
            if (!hasNext) break;
            ++recordCount;
            for (int i = 0; i < dimCount; ++i) {
                MemberImpl member = cdfs[i].fetch(table);
                if (member == null) {
                    ++errorCount;
                    continue block2;
                }
                members[i] = member;
            }
            Object[] values = new Object[measureCount];
            for (int i = 0; i < measureCount; ++i) {
                values[i] = mfs[i].fetch(table);
            }
            data.addRecord(members, values);
        }
        long iterateCost = System.currentTimeMillis() - begin;
        long finishBegin = System.currentTimeMillis();
        data.finishAddRecord(stats);
        table.close();
        buildContext.getTableManager().releaseTable(cubeDef.table);
        for (int i = 0; i < dimCount; ++i) {
            cdfs[i].finish();
        }
        data.finishBuildData(stats);
        long finishCost = System.currentTimeMillis() - finishBegin;
        statItem.append("Cost[input,iterate(next),finish]=[").append(inputCost).append(",").append(iterateCost).append("(").append(nextCost).append("),").append(finishCost).append("]").append(",rows=").append(recordCount);
        if (errorCount > 0) {
            statItem.append(",errorRows=").append(errorCount);
        }
        statItem.close();
        return data;
    }
}

