/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.dbsource.TableProvider;
import kd.bos.algo.olap.def.SchemaDef;
import kd.bos.algo.olap.def.SharedDimensionDef;
import kd.bos.algo.olap.impl.BuildContext;
import kd.bos.algo.olap.impl.DimensionBuildResult;
import kd.bos.algo.olap.impl.DimensionBuilderRunnable;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.OlapThreadPool;
import kd.bos.algo.olap.impl.SchemaImpl;
import kd.bos.algo.olap.impl.Stats;
import org.apache.log4j.Logger;

public class DimensionBuilder {
    private static Logger logger = Logger.getLogger(DimensionBuilder.class);

    public static void build(BuildContext buildContext, SchemaImpl schema, SchemaDef def, Stats stats) throws OlapException, SQLException {
        long begin = System.currentTimeMillis();
        if (OlapThreadPool.support()) {
            ConcurrentHashMap<String, Object> resultHandler = new ConcurrentHashMap<String, Object>();
            CountDownLatch latch = new CountDownLatch(def.dimensions.length);
            for (int i = 0; i < def.dimensions.length; ++i) {
                DimensionImpl dim = schema.dims[i];
                SharedDimensionDef dimDef = def.dimensions[i];
                TableProvider tableProvider = buildContext.getTableManager().getTableProvider(dimDef.table);
                DimensionBuilderRunnable runnable = new DimensionBuilderRunnable(tableProvider, dim, dimDef, resultHandler, latch, stats);
                OlapThreadPool.execute(runnable);
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new OlapException("Erorr when build dimensions.", e);
            }
            Throwable error = null;
            for (int i = 0; i < def.dimensions.length; ++i) {
                DimensionImpl dim = schema.dims[i];
                SharedDimensionDef dimDef = def.dimensions[i];
                buildContext.getTableManager().releaseTable(dimDef.table);
                Object result = resultHandler.get(dim.getName());
                if (result instanceof Throwable) {
                    error = (Throwable)result;
                    continue;
                }
                buildContext.setDimensionResult(dim.getName(), (DimensionBuildResult)result);
            }
            if (error != null) {
                if (error instanceof OlapException) {
                    throw (OlapException)error;
                }
                throw new OlapException("Erorr when build dimensions.", error);
            }
        } else {
            for (int i = 0; i < def.dimensions.length; ++i) {
                DimensionImpl dim = schema.dims[i];
                SharedDimensionDef dimDef = def.dimensions[i];
                TableProvider tableProvider = buildContext.getTableManager().getTableProvider(dimDef.table);
                Stats.StatItem item = stats.createStatItem("build dimension:" + dim.getName());
                DimensionBuildResult result = DimensionBuilderRunnable.build(tableProvider, dim, dimDef, item);
                item.close();
                buildContext.getTableManager().releaseTable(dimDef.table);
                buildContext.setDimensionResult(dim.getName(), result);
            }
        }
        long cost = System.currentTimeMillis() - begin;
        logger.info((Object)("Build " + def.dimensions.length + " dimensions cost: " + cost + "ms."));
    }
}

