/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.Iterator;
import java.util.LinkedList;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.OlapElement;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.Property;
import kd.bos.algo.olap.collection.DefaultListFactory;
import kd.bos.algo.olap.collection.IMemberList;
import kd.bos.algo.olap.def.LevelDef;
import kd.bos.algo.olap.impl.CubeElementBase;
import kd.bos.algo.olap.impl.HierarchyImpl;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.MemberIndex;
import kd.bos.algo.olap.impl.PropertyImpl;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.type.LevelType;
import kd.bos.algo.olap.mdx.type.Type;
import kd.bos.algo.olap.util.UniqueNameUtil;

public class LevelImpl
extends CubeElementBase
implements Level {
    public static final long serialVersionUID = 348765589877547547L;
    private transient String uniqueName;
    HierarchyImpl hie;
    byte levelType = 0;
    byte depth = 0;
    PropertyImpl[] props;
    LevelImpl child;
    LevelImpl parent;
    private transient MemberImpl[] members = null;
    private transient MemberIndex memberIndex;

    LevelImpl() {
    }

    @Override
    public Property[] getMemberProperties() {
        return this.props;
    }

    @Override
    public Level getChildLevel() {
        return this.child;
    }

    LevelImpl createChildLevel() {
        if (this.child == null) {
            this.child = new LevelImpl();
            this.child.hie = this.hie;
            this.child.levelType = this.levelType;
            this.child.depth = (byte)(this.depth + 1);
            this.child.props = this.props;
            this.child.parent = this;
            this.child.name = "Level #" + (this.depth + 1);
            if (this.child.hie.depth < this.depth + 1) {
                this.child.hie.depth = this.depth + 1;
            }
        }
        return this.child;
    }

    @Override
    public Level getParentLevel() {
        return this.parent;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.hie;
    }

    @Override
    public byte getDepth() {
        return this.depth;
    }

    @Override
    public byte getLevelType() {
        return this.levelType;
    }

    public Type getExpType() {
        return new LevelType(this.hie, this);
    }

    public int getCategory() {
        return 4;
    }

    public void createMembers() {
        if (this.members != null) {
            return;
        }
        IMemberList result = DefaultListFactory.instance.createMemberList();
        LinkedList tempList = new LinkedList();
        if (this.hie.getMembers() != null) {
            Iterator iter = this.hie.getMembers().iterator();
            while (iter.hasNext()) {
                tempList.add(iter.next());
            }
        }
        while (tempList.size() > 0) {
            int i;
            MemberImpl[] children;
            MemberImpl m = (MemberImpl)tempList.removeFirst();
            byte depth2 = m.getLevel().getDepth();
            if (depth2 == this.depth) {
                result.add(m);
                continue;
            }
            if (depth2 >= this.depth || (children = m.getChildren()) == null) continue;
            if (depth2 == this.depth - 1) {
                for (i = 0; i < children.length; ++i) {
                    result.add(children[i]);
                }
                continue;
            }
            for (i = 0; i < children.length; ++i) {
                tempList.add(children[i]);
            }
        }
        this.members = new MemberImpl[result.size()];
        result.toArray(this.members);
    }

    public IMemberList getMemberList() {
        if (this.members == null) {
            this.createMembers();
        }
        return DefaultListFactory.instance.createMemberList(this.members);
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String name) throws OlapException {
        if (this.memberIndex == null) {
            this.memberIndex = new MemberIndex(false);
            if (this.members == null) {
                this.createMembers();
            }
            MemberImpl found = null;
            for (int i = 0; i < this.members.length; ++i) {
                MemberImpl m = this.members[i];
                this.memberIndex.put(name, m);
                if (!m.getName().equals(name)) continue;
                found = m;
            }
            return found;
        }
        return this.memberIndex.get(name);
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = UniqueNameUtil.makeUniqueName(this.hie, this.getName());
        }
        return this.uniqueName;
    }

    @Override
    public boolean isAll() {
        return this.levelType == -1;
    }

    @Override
    public boolean isMeasures() {
        return this.levelType == -2;
    }

    @Override
    public Dimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            if (this.isAll()) {
                return "All";
            }
            return "Level #" + (this.depth + 1);
        }
        return name;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    @Override
    public LevelDef getLevelDef() {
        return null;
    }
}

