/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.olap.Cell;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.impl.AxisImpl;
import kd.bos.algo.olap.impl.CellImpl;
import kd.bos.algo.olap.impl.CellKey;
import kd.bos.algo.olap.impl.CellReaderImpl;
import kd.bos.algo.olap.impl.CellValues;
import kd.bos.algo.olap.impl.ConnectionImpl;
import kd.bos.algo.olap.impl.CubeImpl;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.EvaluatorImpl;
import kd.bos.algo.olap.impl.MdxResultBase;
import kd.bos.algo.olap.impl.PositionImpl;
import kd.bos.algo.olap.impl.Stats;
import kd.bos.algo.olap.mdx.CellReader;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.MdxQuery;
import kd.bos.algo.olap.mdx.QueryAxis;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.Scope;
import kd.bos.algo.olap.util.Util;
import org.apache.log4j.Logger;

public class MdxResultImpl
extends MdxResultBase {
    private static final Logger logger = Logger.getLogger(MdxResultImpl.class);
    private final CellValues cellValues;
    private transient CellKey point;
    private transient HashMap<QueryAxis, IList> axisPositionList;
    private boolean x = false;
    private HashMap axis0PositionMap;
    private ConnectionImpl cn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdxResultImpl(MdxQuery query, List<String[]>[] filters, Stats stats) throws OlapException {
        super(query, new AxisImpl[query.getAxes().length]);
        this.point = new CellKey(new int[query.getAxes().length]);
        CubeImpl cube = (CubeImpl)query.getCube();
        this.cn = (ConnectionImpl)query.getConnection();
        CellReaderImpl cellReader = new CellReaderImpl(this.cn.database.getCubeDataReader(cube));
        EvaluatorImpl evaluator = new EvaluatorImpl(query, cube, cellReader);
        this.cellValues = new CellValues();
        this.axisPositionList = new HashMap();
        boolean allNonEmpty = false;
        Set cellCalculatedMemberSet = query.getCellCalculationMemberSet(evaluator.push());
        QueryAxis[] queryAxes = query.getAxes();
        if (queryAxes[0].isNonEmpty() && !queryAxes[1].isNonEmpty()) {
            this.x = true;
        } else if (queryAxes[0].isNonEmpty() && queryAxes[1].isNonEmpty()) {
            allNonEmpty = true;
        }
        ArrayList[] memFilters = null;
        if (filters != null && filters.length > 0) {
            Member _member = null;
            HashMap dimMemberMap = new HashMap();
            Map<String, Member> memberMap = null;
            int xn = cube.getDimensions().length;
            for (int x = 0; x < xn; ++x) {
                DimensionImpl dim = (DimensionImpl)cube.getDimensions()[x];
                if (dimMemberMap.containsKey(dim.getName())) {
                    memberMap = (Map)dimMemberMap.get(dim.getName());
                } else {
                    memberMap = new HashMap();
                    dimMemberMap.put(dim.getName(), memberMap);
                }
                Iterator<Member> iter = dim.memberIterator();
                while (iter.hasNext()) {
                    _member = iter.next();
                    memberMap.put(_member.getName(), _member);
                }
            }
            memFilters = new ArrayList[filters.length];
            List<String[]> _filter2 = null;
            ArrayList<Member[]> _bFilter = null;
            Member[] _members = null;
            for (List<String[]> _filter2 : filters) {
                if (_filter2 == null || _filter2.size() <= 1) continue;
                _bFilter = new ArrayList<Member[]>();
                String[] numbers = null;
                String[] fields = _filter2.get(0);
                int yn = _filter2.size();
                for (int y = 1; y < yn; ++y) {
                    numbers = _filter2.get(y);
                    if (numbers == null) continue;
                    _members = new Member[numbers.length];
                    int zn = fields.length;
                    for (int z = 0; z < zn; ++z) {
                        memberMap = (Map)dimMemberMap.get(fields[z]);
                        if (memberMap == null) continue;
                        _members[z] = (Member)memberMap.get(numbers[z]);
                        if (_members[z] != null) continue;
                        logger.error((Object)("filter field -> " + fields[z] + " Number -> " + numbers[z] + " not find."));
                        _members = null;
                        break;
                    }
                    if (_members == null) continue;
                    _bFilter.add(_members);
                }
                memFilters[x] = _bFilter;
            }
        }
        try {
            Calc slicerCalc = query.getSlicerCalc();
            if (slicerCalc != null) {
                Scope scope = new Scope(slicerCalc, false, Scope.NeedHierarchize.No);
                slicerCalc = slicerCalc.optimize(scope, evaluator);
            }
            query.setSlicerCalc(slicerCalc);
            this.executeSliceAxis(evaluator.push(), slicerCalc);
            IList slicerPositions = this.axisPositionList.get(null);
            Member[] slicerPosition = (Member[])slicerPositions.get(0);
            evaluator.setContext(slicerPosition);
            evaluator.setSlicerMember(slicerPosition);
            Calc calc = null;
            for (int i = 0; i < this.axes.length; ++i) {
                QueryAxis axis = query.getAxes()[i];
                calc = query.getAxisCalcs()[i];
                if (calc != null) {
                    Scope scope = new Scope(calc, axis.isNonEmpty(), Scope.NeedHierarchize.Unknow);
                    calc = calc.optimize(scope, evaluator);
                }
                query.getAxisCalcs()[i] = calc;
                IList list = this.executeAxis(cellReader, evaluator.push(), axis, calc);
                this.axisPositionList.put(axis, list);
                evaluator.clearExpResultCache(false);
            }
            if (allNonEmpty) {
                QueryAxis axis = query.getAxes()[0];
                IList list0 = this.axisPositionList.get(axis);
                axis = query.getAxes()[1];
                IList list1 = this.axisPositionList.get(axis);
                if (list0.size() > 1500 && list1.size() > 1500) {
                    throw new OlapException("Too much query axis,two query axis exceed 1500 positions,please reduce one query axis range.");
                }
                if (list0.size() > list1.size()) {
                    this.x = true;
                }
            }
            long t1 = System.currentTimeMillis();
            this.executeBody(cellReader, evaluator, query, cellCalculatedMemberSet, memFilters);
            this.println("MdxResultImpl.executeBody:" + (System.currentTimeMillis() - t1) + " ms.");
            this.println("MdxQuery.useTime:" + query.useTime + " ms.");
            this.println("CellValues size: " + this.cellValues.values.size());
            stats.appendMessage("MdxQuery.useTime:" + query.useTime + " ms.");
            stats.appendMessage("CellValues size: " + this.cellValues.values.size());
            this.cn.database.printStatistics(stats);
            IList positions2 = null;
            if (allNonEmpty) {
                int axisIndex = this.getAxisIndex(0);
                IList positions = this.axisPositionList.get(query.getAxes()[axisIndex]);
                positions2 = query.getListFactory().createArrayList();
                int index = 0;
                int[] pos = new int[2];
                int i = 0;
                this.axis0PositionMap = new HashMap();
                if (!this.cellValues.values.isEmpty()) {
                    Iterator iter = positions.iterator();
                    while (iter.hasNext()) {
                        Member[] position = this.toMemberArray(iter.next());
                        if (!this.isEmpty(pos, i, axisIndex)) {
                            this.axis0PositionMap.put(index, i);
                            positions2.add(position);
                            ++index;
                        }
                        ++i;
                    }
                }
            }
            for (int i = -1; i < this.axes.length; ++i) {
                IList list;
                QueryAxis axis = i == -1 ? null : query.getAxes()[i];
                if (this.axis0PositionMap != null && this.getAxisIndex(0) == i) {
                    list = positions2;
                    this.axisPositionList.remove(axis);
                } else {
                    list = this.axisPositionList.remove(axis);
                }
                if (list == null) {
                    throw new OlapException("can't go here, just for sonar check.");
                }
                int returnCount = list.size();
                PositionImpl[] positions = new PositionImpl[returnCount];
                Iterator iter = list.iterator();
                for (int index = 0; iter.hasNext() && index < returnCount; ++index) {
                    positions[index] = new PositionImpl(this.toMemberArray(iter.next()));
                }
                AxisImpl mdxAxis = new AxisImpl(axis == null ? "" : axis.getName(), query.getMdxHierarchiesOnAxis(i), positions);
                if (i == -1) {
                    this.slicerAxis = mdxAxis;
                    continue;
                }
                this.axes[i] = mdxAxis;
            }
            this.axisPositionList = null;
        }
        finally {
            evaluator.clearExpResultCache(true);
        }
    }

    private void println(String message) {
        logger.info((Object)message);
    }

    private Member[] toMemberArray(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Member[]) {
            return (Member[])o;
        }
        if (o instanceof Member) {
            return new Member[]{(Member)o};
        }
        if (o instanceof Object[]) {
            Object[] os = (Object[])o;
            Member[] ms = new Member[os.length];
            System.arraycopy(os, 0, ms, 0, os.length);
            return ms;
        }
        throw new ClassCastException();
    }

    private boolean isEmpty(int[] pos, int offset, int fixedAxis) {
        int axisCount = this.getAxes().length;
        pos[fixedAxis] = offset;
        return this.isEmptyRecurse(pos, fixedAxis, axisCount - 1);
    }

    private boolean isEmptyRecurse(int[] pos, int fixedAxis, int axis) {
        if (axis < 0) {
            Object value = this.cellValues.get(new CellKey(pos));
            return value == null;
        }
        if (axis == fixedAxis) {
            return this.isEmptyRecurse(pos, fixedAxis, axis - 1);
        }
        IList positions = this.axisPositionList.get(this.query.getAxes()[axis]);
        int i = 0;
        int count = positions.size();
        while (i < count) {
            pos[axis] = i++;
            if (this.isEmptyRecurse(pos, fixedAxis, axis - 1)) continue;
            return false;
        }
        return true;
    }

    private int getAxisIndex(int index) {
        return this.x ? (index + 1) % 2 : index;
    }

    private QueryAxis getAxis(int index) {
        return this.query.getAxes()[this.getAxisIndex(index)];
    }

    private IList executeAxis(CellReader cellReader, Evaluator evaluator, QueryAxis axis, Calc calc) throws OlapException {
        boolean nonEmpty = axis.isNonEmpty();
        evaluator.setNonEmpty(nonEmpty);
        boolean nonFactEmpty = axis.isNonFactEmpty();
        evaluator.setNonFactEmpty(nonFactEmpty);
        Object value = calc.evaluate(evaluator);
        evaluator.setNonEmpty(false);
        evaluator.setNonFactEmpty(false);
        if (value == null) {
            value = Collections.EMPTY_LIST;
        }
        return (IList)value;
    }

    private IList executeSliceAxis(Evaluator evaluator, Calc calc) throws OlapException {
        IList positions = this.query.getListFactory().createArrayList();
        if (calc == null) {
            Member[] members = new Member[]{};
            positions.add(members);
        } else {
            IList list;
            Object value = calc.evaluate(evaluator);
            if (value instanceof Member || value instanceof Member[]) {
                list = this.query.getListFactory().createArrayList();
                list.add(value);
                value = list;
            }
            list = (IList)value;
            Object o = list.getFirst();
            IList members = this.query.getListFactory().createArrayList();
            if (o != null) {
                if (o instanceof Object[]) {
                    Object[] a = (Object[])o;
                    HashMap<Hierarchy, IList> map = new HashMap<Hierarchy, IList>(3);
                    for (int j = 0; j < a.length; ++j) {
                        if (a[j] == null) continue;
                        Member tm = (Member)a[j];
                        members.add(tm);
                        o = map.get(tm.getHierarchy());
                        if (o != null) {
                            ((IList)o).add(tm);
                            continue;
                        }
                        IList l = this.query.getListFactory().createArrayList();
                        l.add(tm);
                        map.put(tm.getHierarchy(), l);
                    }
                    if (map.size() != members.size()) {
                        for (Map.Entry entry : map.entrySet()) {
                            Hierarchy hier = (Hierarchy)entry.getKey();
                            IList memberList = (IList)entry.getValue();
                            if (memberList.size() == 1) {
                                members.add(memberList.get(0));
                                continue;
                            }
                            throw new OlapException("Slice only support one tuple.");
                        }
                    }
                } else {
                    members.add(o);
                }
            }
            positions.add((Member[])members.toArray(new Member[0]));
        }
        this.axisPositionList.put(null, positions);
        return positions;
    }

    private void executeBody(CellReader cellReader, EvaluatorImpl evaluator, MdxQuery query, Set cellCalculatedMemberSet, List<Member[]>[] filters) throws OlapException {
        this.cellValues.clear();
        this.executeStripe(1, (EvaluatorImpl)evaluator.push(), cellCalculatedMemberSet, filters);
        evaluator.clearExpResultCache(false);
    }

    private StripeResult executeStripe(int axis, EvaluatorImpl evaluator, Set cellCalculatedMemberSet, List<Member[]>[] filters) throws OlapException {
        boolean allNull;
        IList positions2;
        QueryAxis queryAxis;
        block23: {
            int count;
            int i;
            IList positions;
            boolean nonempty;
            block22: {
                if (axis < 0) {
                    Member[] context = null;
                    Member contextMeasure = evaluator.getCurrentMeasure();
                    Object o = null;
                    context = (Member[])evaluator.getCurrentMembers().clone();
                    o = evaluator.evaluateCurrent();
                    if (o != null && o != Util.nullValue && !(o instanceof Exception)) {
                        return new StripeResult(new CellImpl(context, contextMeasure, o, null), false);
                    }
                    return new StripeResult(null, false);
                }
                queryAxis = this.getAxis(axis);
                nonempty = queryAxis.isNonEmpty();
                positions = this.axisPositionList.get(queryAxis);
                positions2 = this.query.getListFactory().createArrayList();
                i = 0;
                allNull = true;
                count = 0;
                int axisIndex = this.getAxisIndex(axis);
                List<Member[]> _filter = null;
                if (filters != null && filters.length > axisIndex) {
                    _filter = filters[axisIndex];
                }
                if (_filter == null || _filter.isEmpty()) break block22;
                int xn = _filter.size();
                for (int x = 0; x < xn; ++x) {
                    Member[] members = _filter.get(x);
                    if (nonempty) {
                        boolean empty = false;
                        for (int j = 0; j < members.length; ++j) {
                            if (members[j].hasData() || members[j].maybeNeedCalc() || cellCalculatedMemberSet.contains(members[j])) continue;
                            empty = true;
                            break;
                        }
                        if (empty) continue;
                    }
                    evaluator.setContext(members);
                    StripeResult sr = this.executeStripe(axis - 1, evaluator, cellCalculatedMemberSet, filters);
                    if (axis == 1) {
                        if (sr.allNull && nonempty) continue;
                        this.point.ordinals[this.getAxisIndex((int)axis)] = ++i;
                    } else {
                        boolean nonfactempty = axis == 0 ? this.getAxis(1).isNonFactEmpty() : this.getAxis(0).isNonFactEmpty();
                        this.point.ordinals[this.getAxisIndex((int)axis)] = i++;
                        if (sr.cell != null) {
                            CellKey key = this.point.copy();
                            this.cellValues.put(key, sr.cell);
                            if (allNull) {
                                if (nonfactempty) {
                                    Member[] ms = sr.cell.getMemberContext();
                                    Member measureMember = ms[ms.length - 1];
                                    if (!measureMember.isCalculated()) {
                                        allNull = false;
                                    }
                                } else {
                                    allNull = false;
                                }
                            }
                        }
                    }
                    positions2.add(members);
                }
                break block23;
            }
            Iterator iter = positions.iterator();
            while (iter.hasNext()) {
                block25: {
                    Member[] members;
                    block27: {
                        StripeResult sr;
                        block26: {
                            block24: {
                                members = this.toMemberArray(iter.next());
                                if (!nonempty) break block24;
                                boolean empty = false;
                                for (int j = 0; j < members.length; ++j) {
                                    if (members[j].hasData() || members[j].maybeNeedCalc() || cellCalculatedMemberSet.contains(members[j])) continue;
                                    empty = true;
                                    break;
                                }
                                if (empty) break block25;
                            }
                            evaluator.setContext(members);
                            sr = this.executeStripe(axis - 1, evaluator, cellCalculatedMemberSet, filters);
                            if (axis != 1) break block26;
                            if (sr.allNull && nonempty) break block25;
                            this.point.ordinals[this.getAxisIndex((int)axis)] = ++i;
                            break block27;
                        }
                        boolean nonfactempty = axis == 0 ? this.getAxis(1).isNonFactEmpty() : this.getAxis(0).isNonFactEmpty();
                        this.point.ordinals[this.getAxisIndex((int)axis)] = i++;
                        if (sr.cell != null) {
                            CellKey key = this.point.copy();
                            this.cellValues.put(key, sr.cell);
                            if (allNull) {
                                if (nonfactempty) {
                                    Member[] ms = sr.cell.getMemberContext();
                                    Member measureMember = ms[ms.length - 1];
                                    if (!measureMember.isCalculated()) {
                                        allNull = false;
                                    }
                                } else {
                                    allNull = false;
                                }
                            }
                        }
                    }
                    positions2.add(members);
                }
                ++count;
            }
        }
        this.axisPositionList.put(queryAxis, positions2);
        return new StripeResult(null, allNull);
    }

    @Override
    public Cell getCell(int[] pos) {
        Object value;
        int[] pos2 = (int[])pos.clone();
        if (this.axis0PositionMap != null) {
            pos2[this.getAxisIndex((int)0)] = (Integer)this.axis0PositionMap.get(pos[this.getAxisIndex(0)]);
        }
        if ((value = this.cellValues.get(new CellKey(pos2))) == null) {
            return new CellImpl(this.getMembers(pos));
        }
        return (Cell)value;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Cells:");
        Iterator<Cell> iter = this.cellValues.cellIterator();
        while (iter.hasNext()) {
            Cell cell = iter.next();
            str.append("\r\n");
            str.append(cell.toString());
        }
        return str.toString();
    }

    @Override
    public Iterator<Cell> getCellIterator() {
        return this.cellValues.cellIterator();
    }

    private static class StripeResult {
        CellImpl cell;
        boolean allNull;

        public StripeResult(CellImpl cell, boolean allNull) {
            this.cell = cell;
            this.allNull = allNull;
        }
    }
}

