/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.olap.LeafFeature;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.impl.MemberCalcResult;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.ScopedCalc;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;

public class MemberCalcFeature {
    private Calc leafDefaultCalc = null;
    private Calc notLeafDefaultCalc = null;
    private List<ScopedCalc> leafCalcList = null;
    private List<ScopedCalc> notLeafCalcList = null;
    private MemberImpl member;
    private Calc aggregationCalc = null;

    MemberCalcFeature(MemberImpl member, Evaluator evaluator) {
        List<ScopedCalc> calcList;
        this.member = member;
        if (member.exp != null) {
            LeafFeature lf;
            if (member.calc == null) {
                member.calc = evaluator.getContext().compileExpression(member.exp, true);
            }
            if ((lf = member.getLeafFeature()).contains(true)) {
                this.leafDefaultCalc = member.calc;
            }
            if (lf.contains(false)) {
                this.notLeafDefaultCalc = member.calc;
            }
        }
        if ((calcList = member.getScopedCalcList()) == null || calcList.isEmpty()) {
            return;
        }
        ArrayList<ScopedCalc> leafCalcList = new ArrayList<ScopedCalc>(2);
        ArrayList<ScopedCalc> notLeafCalcList = new ArrayList<ScopedCalc>(2);
        for (ScopedCalc sc : calcList) {
            LeafFeature lf = sc.getLeafFeature();
            sc.scopeIndex.build(evaluator);
            if (lf.contains(true) && !sc.scopeIndex.noScope) {
                leafCalcList.add(sc);
            }
            if (!lf.contains(false) || sc.scopeIndex.noScope) continue;
            notLeafCalcList.add(sc);
        }
        if (this.leafDefaultCalc == null && leafCalcList.size() > 0) {
            this.leafCalcList = leafCalcList;
        }
        if (this.notLeafDefaultCalc == null && notLeafCalcList.size() > 0) {
            this.notLeafCalcList = notLeafCalcList;
        }
    }

    public Calc getDefaultLeafCalc() {
        return this.leafDefaultCalc;
    }

    public List<ScopedCalc> getLeafCalcs() {
        return this.leafCalcList;
    }

    public MemberCalcResult query(Member[] members, boolean leaf, Evaluator evaluator) {
        ArrayList<ScopedCalc> list;
        MemberCalcResult result = new MemberCalcResult();
        if (leaf) {
            if (this.leafDefaultCalc != null) {
                result.calc = this.leafDefaultCalc;
                return result;
            }
            if (this.leafCalcList != null) {
                for (ScopedCalc sc : this.leafCalcList) {
                    if (!sc.validate(members)) continue;
                    result.calc = sc.getCalc();
                    return result;
                }
            }
            return null;
        }
        if (this.notLeafDefaultCalc != null) {
            result.calc = this.notLeafDefaultCalc;
            return result;
        }
        if (this.leafDefaultCalc != null) {
            result.leafDefaultCalc = this.leafDefaultCalc;
            return result;
        }
        if (this.notLeafCalcList != null) {
            for (ScopedCalc sc : this.notLeafCalcList) {
                if (!sc.validate(members)) continue;
                result.calc = sc.getCalc();
                return result;
            }
            list = new ArrayList(2);
            for (ScopedCalc sc : this.notLeafCalcList) {
                if (!sc.scopeIndex.inBBFilter(members)) continue;
                list.add(sc);
            }
            if (list.size() > 0) {
                result.notLeafScopedCalcList = list;
            }
        }
        if (this.leafCalcList != null) {
            list = new ArrayList<ScopedCalc>(2);
            for (ScopedCalc sc : this.leafCalcList) {
                if (!sc.scopeIndex.inBBFilter(members)) continue;
                list.add(sc);
            }
            if (list.size() > 0) {
                result.leafScopedCalcList = list;
            }
        }
        if (result.notLeafScopedCalcList != null || result.leafScopedCalcList != null) {
            return result;
        }
        List<ScopedCalc> scs = this.member.getLeafChildrenScopedCalcList();
        if (scs != null) {
            for (ScopedCalc sc : scs) {
                sc.scopeIndex.build(evaluator);
                if (!sc.scopeIndex.inBBFilter(members)) continue;
                result.calc = this.makeAggregationCalc(evaluator);
                return result;
            }
        }
        return null;
    }

    private Calc makeAggregationCalc(Evaluator evaluator) {
        if (this.aggregationCalc != null) {
            return this.aggregationCalc;
        }
        Exp exp = this.member.getAggregationExp();
        this.aggregationCalc = evaluator.getContext().compileExpression(exp, true);
        return this.aggregationCalc;
    }

    public void removeLeafCalcs() {
        this.leafCalcList = null;
        this.leafDefaultCalc = null;
    }
}

