/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.impl.BBFilterIndex;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.EvaluateContext;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.MemberScopeImpl;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.util.BitSetFactory;
import kd.bos.algo.olap.util.IntBitSet;
import kd.bos.algo.olap.util.Pair;

public class MemberScopeIndex {
    public boolean noScope = false;
    private int[] bindexes;
    private IntBitSet[] bitSets;
    private BBFilterIndex bbFilter;
    private boolean builded = false;
    private MemberScopeImpl scope;
    private ParentMemberScopeIndex parentScope;
    private DimMatrix dimMatrix = null;

    public MemberScopeIndex(MemberScopeImpl scope) {
        this.scope = scope;
    }

    public void build(Evaluator evaluator) {
        DimInfo dimInfo;
        if (this.builded) {
            return;
        }
        this.builded = true;
        if (this.scope.list.isEmpty()) {
            this.noScope = true;
            return;
        }
        EvaluateContext ec = evaluator.getContext();
        Cube cube = ec.getSchemaReader().getCube();
        ArrayList<DimInfo> dimInfos = new ArrayList<DimInfo>();
        for (Pair<String, String> pair : this.scope.list) {
            MemberImpl member;
            String dimName = pair.getValue0();
            dimInfo = new DimInfo((DimensionImpl)cube.getDimension(dimName), cube.getDimensionOrdinal(dimName));
            dimInfos.add(dimInfo);
            String expression = pair.getValue1();
            Exp exp = ec.parseExpression(expression, true);
            Calc calc = ec.compileExpression(exp, false);
            Object value = calc.evaluate(evaluator);
            if (value instanceof IList) {
                Iterator iter = ((IList)value).iterator();
                while (iter.hasNext()) {
                    member = (MemberImpl)iter.next();
                    if (member.isCalculated()) {
                        throw new OlapException("Calculated member not support in scope: " + member.getUniqueName());
                    }
                    dimInfo.bitSet.set(member.getGlobalOrder());
                    member.setHasData(true);
                    dimInfo.members.add(member);
                }
                continue;
            }
            if (!(value instanceof Member)) continue;
            member = (MemberImpl)value;
            if (member.isCalculated()) {
                throw new OlapException("Calculated member not support in scope: " + member.getUniqueName());
            }
            dimInfo.bitSet.set(member.getGlobalOrder());
            member.setHasData(true);
            dimInfo.members.add(member);
        }
        Iterator iter = dimInfos.iterator();
        while (iter.hasNext()) {
            DimInfo dimInfo2 = (DimInfo)iter.next();
            if (dimInfo2.members.isEmpty()) {
                this.noScope = true;
                return;
            }
            if (dimInfo2.members.size() != 1 || dimInfo2.dim.getRealOrOriginMemberCount() != 1) continue;
            iter.remove();
        }
        Collections.sort(dimInfos, new Comparator<DimInfo>(){

            @Override
            public int compare(DimInfo o1, DimInfo o2) {
                return o2.members.size() - o1.members.size();
            }
        });
        int size = dimInfos.size();
        DimensionImpl[] dims = new DimensionImpl[size];
        HashSet[] dimMembers = new HashSet[size];
        this.bitSets = new IntBitSet[size];
        this.bindexes = new int[size];
        for (int i = 0; i < dims.length; ++i) {
            dimInfo = (DimInfo)dimInfos.get(i);
            dims[i] = dimInfo.dim;
            dimMembers[i] = dimInfo.members;
            this.bitSets[i] = dimInfo.bitSet;
            this.bindexes[i] = dimInfo.dimOrder;
        }
        this.dimMatrix = new DimMatrix(evaluator.getCube(), dims, dimMembers);
    }

    public BBFilterIndex getBBFilter() {
        return this.bbFilter;
    }

    public int[] getDimOrdinals() {
        return this.bindexes;
    }

    public boolean inBBFilter(Member[] members) {
        if (this.dimMatrix != null) {
            return this.dimMatrix.inBBFilter(members);
        }
        return false;
    }

    private BBFilterIndex buildIndex(Evaluator evaluator, DimensionImpl[] dims, HashSet<Member>[] dimMembers) {
        BBFilterIndex index = new BBFilterIndex(evaluator.getCube(), dims);
        Member[] members = new Member[dims.length];
        this.traverse(index, members, dimMembers, 0);
        return index;
    }

    private void traverse(BBFilterIndex index, Member[] members, HashSet<Member>[] dimMembers, int i) {
        boolean end;
        Iterator<Member> iterator = this.parentScope.getIterator(dimMembers[i], i);
        boolean bl = end = i == dimMembers.length - 1;
        if (end) {
            while (iterator.hasNext()) {
                members[i] = iterator.next();
                this.buildBB(index, members);
            }
        } else {
            while (iterator.hasNext()) {
                members[i] = iterator.next();
                this.traverse(index, members, dimMembers, i + 1);
            }
        }
    }

    private void buildBB(BBFilterIndex index, Member ... members) {
        if (index.getRaw(members)) {
            return;
        }
        index.addRaw(members);
        for (int i = 0; i < members.length; ++i) {
            Member parent = members[i].getParentMember();
            if (parent == null || index.getRaw(members, parent, i)) continue;
            Member[] members2 = new Member[members.length];
            System.arraycopy(members, 0, members2, 0, members.length);
            members2[i] = parent;
            this.buildBB(index, members2);
        }
    }

    public boolean validate(Member[] members, Evaluator evaluator) {
        if (!this.builded) {
            this.build(evaluator);
        }
        return this.validate(members);
    }

    public boolean validate(Member[] members) {
        for (int i = 0; i < this.bindexes.length; ++i) {
            if (this.bitSets[i].get(members[this.bindexes[i]].getGlobalOrder())) continue;
            return false;
        }
        return true;
    }

    public static class DimMatrix {
        private final int[] dimIndexs;
        private final Set<Integer>[] memberScope;

        public DimMatrix(Cube cube, DimensionImpl[] dims, HashSet<Member>[] dimMembers) {
            int dimSize = dims.length;
            this.dimIndexs = new int[dimSize];
            this.memberScope = new Set[dimSize];
            int in = dims.length;
            for (int i = 0; i < in; ++i) {
                DimensionImpl _dim = dims[i];
                this.dimIndexs[i] = _dim.getOrdinal(cube);
                LinkedHashSet<Integer> scopes = new LinkedHashSet<Integer>();
                HashSet<Member> _members = dimMembers[i];
                _members.forEach(m -> scopes.add(m.getGlobalOrder()));
                this.memberScope[i] = scopes;
            }
        }

        public boolean inBBFilter(Member[] members) {
            boolean hasIn = true;
            for (int i = 0; i < this.dimIndexs.length && hasIn; ++i) {
                int _index = this.dimIndexs[i];
                hasIn = this.memberScope[i].contains(members[_index].getGlobalOrder());
            }
            return hasIn;
        }
    }

    public static class ParentMemberScopeIndex {
        private boolean hasParent = false;
        private final boolean[] hasParents;
        private final int[] dimIndexs;
        private final Map<Integer, Integer>[] memberIndex;
        private final Set<Member>[] parents;
        private static final int parentLevel = 4;
        private static final int parentSize = 10;
        private final int[] coords;
        private static final String IGNORE_DIMS = "BP";

        public ParentMemberScopeIndex(Cube cube, DimensionImpl[] dims) {
            int dimSize = dims.length;
            this.hasParents = new boolean[dimSize];
            this.dimIndexs = new int[dimSize];
            this.memberIndex = new Map[dimSize];
            this.parents = new Set[dimSize];
            this.coords = new int[dimSize];
            int in = dims.length;
            for (int i = 0; i < in; ++i) {
                DimensionImpl _dim = dims[i];
                this.dimIndexs[i] = _dim.getOrdinal(cube);
                int count = _dim.getRealMemberCount();
                if (count == 0) {
                    count = _dim.getMemberCount();
                }
                boolean bl = this.hasParents[i] = count > 10 && !IGNORE_DIMS.equals(_dim.getName());
                if (!this.hasParents[i]) continue;
                this.hasParent = true;
                this.memberIndex[i] = new HashMap<Integer, Integer>(count);
            }
        }

        public boolean isHasParent() {
            return this.hasParent;
        }

        public Iterator<Member> getIterator(HashSet<Member> members, int index) {
            if (this.hasParents[index]) {
                if (this.parents[index] == null) {
                    LinkedHashSet<Member> _parents = new LinkedHashSet<Member>(members.size());
                    members.forEach(m -> _parents.add(this.getParentMember(index, (Member)m)));
                    this.parents[index] = _parents;
                }
                return this.parents[index].iterator();
            }
            return members.iterator();
        }

        public Member getParentMember(int dimIndex, Member member) {
            Member _last;
            Member _parent = _last = member;
            for (int i = 0; i < 4; ++i) {
                if ((_parent = _parent.getParentMember()) == null) {
                    _parent = _last;
                    break;
                }
                _last = _parent;
            }
            this.memberIndex[dimIndex].put(member.getGlobalOrder(), _parent.getGlobalOrder());
            return _parent;
        }

        public boolean inBBFilter(Member[] members, BBFilterIndex bbFilter) {
            for (int i = 0; i < this.dimIndexs.length; ++i) {
                int _index = this.dimIndexs[i];
                this.coords[i] = this.hasParents[i] ? this.memberIndex[i].get(members[_index].getGlobalOrder()).intValue() : members[_index].getGlobalOrder();
            }
            return bbFilter.getFilter().get(this.coords);
        }
    }

    private static class DimInfo {
        private DimensionImpl dim;
        private IntBitSet bitSet;
        private int dimOrder;
        private HashSet<Member> members;

        DimInfo(DimensionImpl dim, int dimOrder) {
            this.dim = dim;
            this.dimOrder = dimOrder;
            this.bitSet = BitSetFactory.createIntBitSet();
            this.members = new HashSet();
        }
    }
}

