/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapElement;
import kd.bos.algo.olap.Partition;
import kd.bos.algo.olap.Relation;
import kd.bos.algo.olap.Schema;
import kd.bos.algo.olap.impl.CubeElementBase;
import kd.bos.algo.olap.impl.CubeImpl;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.PartitionImpl;
import kd.bos.algo.olap.impl.RelationImpl;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.type.Type;

public class SchemaImpl
extends CubeElementBase
implements Schema {
    public static final long serialVersionUID = 16534687477547547L;
    DimensionImpl[] dims;
    RelationImpl[] relations;
    CubeImpl[] cubes;
    public PartitionImpl partition;
    private transient HashMap<String, OlapElement> cache = null;

    @Override
    public Cube getCube() {
        return this.cubes[0];
    }

    @Override
    public Cube[] getCubes() {
        return this.cubes;
    }

    @Override
    public Cube getCube(String name) {
        for (int i = 0; i < this.cubes.length; ++i) {
            if (!this.cubes[i].getName().equalsIgnoreCase(name)) continue;
            return this.cubes[i];
        }
        return null;
    }

    @Override
    public Dimension[] getDimensions() {
        return this.dims;
    }

    @Override
    public Partition getPartition() {
        return this.partition;
    }

    @Override
    public Dimension getDimension(String name) {
        for (int i = 0; i < this.dims.length; ++i) {
            if (!this.dims[i].getName().equalsIgnoreCase(name)) continue;
            return this.dims[i];
        }
        return null;
    }

    public Type getExpType() {
        throw new UnsupportedOperationException();
    }

    public int getCategory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUniqueName() {
        return this.getName();
    }

    @Override
    public Hierarchy getHierarchy() {
        return null;
    }

    @Override
    public Dimension getDimension() {
        return null;
    }

    @Override
    public Relation[] getRelations() {
        return this.relations;
    }

    public OlapElement lookupGlobal(SchemaReader schemaReader, String name) {
        if (this.cache == null) {
            this.initCache();
        }
        return this.cache.get(name);
    }

    private void initCache() {
        HashMap<String, OlapElement> map = new HashMap<String, OlapElement>();
        HashSet<String> duplicated = new HashSet<String>();
        CubeImpl cube = (CubeImpl)this.getCube();
        for (DimensionImpl dim : cube.dims) {
            map.put(dim.getName(), dim);
        }
        for (DimensionImpl dim : cube.dims) {
            for (Member member : dim.mapOrderToMember.values()) {
                if (map.put(member.getName(), member) == null) continue;
                duplicated.add(member.getName());
            }
        }
        for (String name : duplicated) {
            map.remove(name);
        }
        this.cache = map;
    }
}

