/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Stats {
    private List<String> messages = Collections.synchronizedList(new ArrayList());
    private List<StatItem> list = Collections.synchronizedList(new ArrayList());
    private long begin = System.currentTimeMillis();
    private long end;

    public void close() {
        this.end = System.currentTimeMillis();
    }

    public long cost() {
        if (this.end == 0L) {
            this.end = System.currentTimeMillis();
        }
        return this.end - this.begin;
    }

    public StatItem createStatItem(String info) {
        StatItem item = new StatItem(info);
        this.list.add(item);
        return item;
    }

    public void appendMessage(String message) {
        this.messages.add(message);
    }

    public String toString(String id) {
        StringBuilder sb = new StringBuilder();
        long cost = this.cost();
        if (cost > 10000L) {
            sb.append("E,");
        } else if (cost > 5000L) {
            sb.append("D,");
        } else if (cost > 2000L) {
            sb.append("C,");
        } else if (cost > 1000L) {
            sb.append("B,");
        } else if (cost > 500L) {
            sb.append("A,");
        }
        sb.append("OlapStats[" + id + "],total cost:").append(cost).append("ms.\r\n");
        for (String message : this.messages) {
            sb.append(message).append(",\r\n");
        }
        for (StatItem item : this.list) {
            item.toString(sb);
            sb.append(",\r\n");
        }
        return sb.toString();
    }

    public static class StatItem {
        private long begin;
        private long end = -1L;
        private String info;

        public StatItem(String info) {
            this.info = info == null ? "" : info;
            this.begin = System.currentTimeMillis();
        }

        public void close() {
            this.end = System.currentTimeMillis();
        }

        public StatItem append(String message) {
            this.info = this.info + "," + message;
            return this;
        }

        public StatItem append(int message) {
            this.info = this.info + "," + message;
            return this;
        }

        public StatItem append(long message) {
            this.info = this.info + "," + message;
            return this;
        }

        public void toString(StringBuilder sb) {
            if (this.end == -1L) {
                return;
            }
            sb.append("cost ").append(this.end - this.begin).append("ms.").append(this.info);
        }
    }
}

