/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx;

import java.io.StringReader;
import kd.bos.algo.olap.Connection;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.impl.Stats;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.Lexer;
import kd.bos.algo.olap.mdx.MdxParseException;
import kd.bos.algo.olap.mdx.MdxQuery;
import kd.bos.algo.olap.mdx.parser;
import kd.bos.cup.Symbol;
import org.apache.log4j.Logger;

public class ParserHelp {
    private static Logger logger = Logger.getLogger(ParserHelp.class);

    public static Exp parseExpression(String expression) throws OlapException {
        try {
            StringReader reader = new StringReader(expression);
            Lexer lexer = new Lexer(reader);
            parser p = new parser(lexer);
            Symbol parse_tree = null;
            parse_tree = p.parse();
            Exp exp = (Exp)parse_tree.value;
            return exp;
        }
        catch (OlapException e) {
            logger.info((Object)("Parse expression error:" + expression));
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)("Parse expression error:" + expression));
            throw new MdxParseException(e.getMessage(), e);
        }
    }

    public static MdxQuery parseQuery(Connection connection, String mdx, Stats stats) throws OlapException {
        long t1 = System.currentTimeMillis();
        try {
            Stats.StatItem item = stats.createStatItem("parse mdx");
            StringReader reader = new StringReader(mdx);
            Lexer lexer = new Lexer(reader);
            parser p = new parser(lexer);
            Symbol parse_tree = null;
            parse_tree = p.parse();
            MdxQuery query = (MdxQuery)parse_tree.value;
            item.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parseQuery mdx 1 cost " + (System.currentTimeMillis() - t1) + "\n"));
            }
            item = stats.createStatItem("resolve mdx");
            query.afterParse(connection);
            item.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parseQuery mdx afterParser cost " + (System.currentTimeMillis() - t1) + "ms.mdx is\n" + mdx));
            }
            return query;
        }
        catch (OlapException e) {
            logger.info((Object)("Parse mdx error:" + mdx));
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)("Parse mdx error:" + mdx));
            throw new MdxParseException(e.getMessage(), e);
        }
    }

    public static void report_error(String message, Object info) {
        logger.debug((Object)("MDX error," + message));
        if (info instanceof Symbol && ((Symbol)info).left != -1) {
            logger.debug((Object)("\nat location" + ((Symbol)info).left + '.'));
        }
    }

    public static void report_fatal_error(String message, Object info) throws Exception {
        String err = "MDX syntax error," + message;
        err = info instanceof Symbol ? (((Symbol)info).left != -1 ? err + "\nat location:" + ((Symbol)info).left : (((Symbol)info).value == null ? err + "\nat end of input." : err + "\nunknown symbol\"" + ((Symbol)info).value + "\"")) : err + "\n" + info.toString();
        logger.debug((Object)err);
        throw new MdxParseException(err);
    }
}

