/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.FunCall;
import kd.bos.algo.olap.mdx.FunDef;
import kd.bos.algo.olap.mdx.FuncResolver;
import kd.bos.algo.olap.mdx.FunctionException;
import kd.bos.algo.olap.mdx.SimpleFuncResolver;
import kd.bos.algo.olap.mdx.Syntax;
import kd.bos.algo.olap.util.IntHolder;

public class UserDefineFunTable {
    private final List resolvers = new ArrayList();
    private HashMap<String, ArrayList<FuncResolver>> mapNameToResolvers = new HashMap();

    public void define(FunDef funDef) {
        this.define(new SimpleFuncResolver(funDef));
    }

    private void define(FuncResolver resolver) {
        if (resolver.getSyntax() == Syntax.Property) {
            throw new OlapException("Not supported");
        }
        this.resolvers.add(resolver);
        String key = UserDefineFunTable.makeResolverKey(resolver.getName(), resolver.getSyntax());
        ArrayList<FuncResolver> v2 = this.mapNameToResolvers.get(key);
        if (v2 == null) {
            v2 = new ArrayList();
            this.mapNameToResolvers.put(key, v2);
        }
        v2.add(resolver);
    }

    private static String makeResolverKey(String name, Syntax syntax) {
        return name.toUpperCase() + "$" + syntax;
    }

    public FunDef getDef(FunCall call) throws OlapException {
        String key = UserDefineFunTable.makeResolverKey(call.getFunction(), call.getSyntax());
        ArrayList<FuncResolver> resolvers = this.mapNameToResolvers.get(key);
        if (resolvers == null || resolvers.isEmpty()) {
            return null;
        }
        IntHolder conversionCount = new IntHolder(0);
        int minConversions = Integer.MAX_VALUE;
        int matchCount = 0;
        FunDef matchDef = null;
        for (FuncResolver resolver : resolvers) {
            conversionCount.value = 0;
            FunDef def = resolver.resolve(call.getArgs(), conversionCount);
            if (def == null) continue;
            int conversions = conversionCount.value;
            if (conversions < minConversions) {
                minConversions = conversions;
                matchCount = 1;
                matchDef = def;
                continue;
            }
            if (conversions != minConversions) continue;
            ++matchCount;
        }
        switch (matchCount) {
            case 0: {
                return null;
            }
            case 1: {
                return matchDef;
            }
        }
        throw new FunctionException("function " + call.toMdx() + " is ambiguous, multiple functions matched.");
    }
}

