/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl;

import java.math.BigDecimal;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.BigDecimalCalc;
import kd.bos.algo.olap.mdx.calc.DoubleCalc;
import kd.bos.algo.olap.mdx.calc.IntegerCalc;
import kd.bos.algo.olap.mdx.calc.StringCalc;
import kd.bos.algo.olap.mdx.calc.VoidCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractCalc;
import kd.bos.algo.olap.util.Util;

public abstract class GenericCalc
extends AbstractCalc
implements StringCalc,
IntegerCalc,
DoubleCalc,
BigDecimalCalc,
VoidCalc {
    protected GenericCalc(Exp exp) {
        super(exp);
    }

    public IList evaluateList(Evaluator evaluator) throws OlapException {
        return (IList)this.evaluate(evaluator);
    }

    @Override
    public String evaluateString(Evaluator evaluator) throws OlapException {
        Object o = this.evaluate(evaluator);
        if (o == null) {
            return null;
        }
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Number) {
            return o.toString();
        }
        if (o instanceof Member) {
            return this.evaluateString(evaluator.push((Member)o));
        }
        throw new OlapException("Can't convert " + this.exp.toMdx() + " to String.");
    }

    @Override
    public int evaluateInteger(Evaluator evaluator) throws OlapException {
        Object o = this.evaluate(evaluator);
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        throw new OlapException("Can't convert " + this.exp.toMdx() + " to Integer.");
    }

    @Override
    public double evaluateDouble(Evaluator evaluator) throws OlapException {
        Object o = this.evaluate(evaluator);
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        }
        Number number = (Number)o;
        return number.doubleValue();
    }

    @Override
    public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OlapException {
        Object o = this.evaluate(evaluator);
        if (o == null) {
            return null;
        }
        if (o instanceof Member) {
            o = evaluator.push((Member)o).evaluateCurrent();
        } else if (o instanceof Number) {
            return Util.toBigDecimal((Number)o);
        }
        throw new OlapException("Can't convert " + this.exp.toMdx() + " to Number.");
    }

    @Override
    public void evaluateVoid(Evaluator evaluator) throws OlapException {
        this.evaluate(evaluator);
    }

    public Member evaluateMember(Evaluator evaluator) throws OlapException {
        return (Member)this.evaluate(evaluator);
    }

    public Level evaluateLevel(Evaluator evaluator) throws OlapException {
        return (Level)this.evaluate(evaluator);
    }

    public Hierarchy evaluateHierarchy(Evaluator evaluator) throws OlapException {
        return (Hierarchy)this.evaluate(evaluator);
    }

    public Dimension evaluateDimension(Evaluator evaluator) throws OlapException {
        return (Dimension)this.evaluate(evaluator);
    }
}

