/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IMemberList;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.DimensionCalc;
import kd.bos.algo.olap.mdx.calc.DummyExp;
import kd.bos.algo.olap.mdx.calc.HierarchyCalc;
import kd.bos.algo.olap.mdx.calc.Scope;
import kd.bos.algo.olap.mdx.calc.impl.AbstractMemberListCalc;
import kd.bos.algo.olap.mdx.calc.impl.ConstantCalc;
import kd.bos.algo.olap.mdx.calc.impl.func.HierarchyMembersCalc;
import kd.bos.algo.olap.mdx.func.FuncUtil2;
import kd.bos.algo.olap.mdx.type.MemberType;
import kd.bos.algo.olap.mdx.type.SetType;

public class DimensionMembersCalc
extends AbstractMemberListCalc {
    DimensionCalc dimensionCalc;
    boolean needNonEmpty = false;
    Scope.NeedHierarchize needHierarchize = Scope.NeedHierarchize.Yes;

    public DimensionMembersCalc(Exp exp, DimensionCalc dimensionCalc) {
        super(exp, new Calc[]{dimensionCalc});
        this.dimensionCalc = dimensionCalc;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OlapException {
        this.needNonEmpty = scope.isNeedNonEmpty();
        this.needHierarchize = scope.getNeedHierarchize();
        Dimension dim = this.dimensionCalc.evaluateDimension(evaluator);
        HierarchyCalc calc = ConstantCalc.constantHierarchy(dim.getDefaultHierarchy());
        return this.getCalc(dim, calc);
    }

    protected Calc getCalc(Dimension dim, HierarchyCalc calc) {
        return new HierarchyMembersCalc((Exp)new DummyExp(new SetType(MemberType.forHierarchy(dim.getDefaultHierarchy()))), calc);
    }

    @Override
    public IMemberList evaluateMemberList(Evaluator evaluator) throws OlapException {
        Dimension dimension = this.dimensionCalc.evaluateDimension(evaluator);
        Hierarchy hierarchy = dimension.getDefaultHierarchy();
        IMemberList members = FuncUtil2.getHierarchizeMembers(evaluator.getSchemaReader(), hierarchy, this.needHierarchize != Scope.NeedHierarchize.No);
        if (this.needNonEmpty) {
            members = FuncUtil2.nonFactEmptyMembers(evaluator, members);
        }
        return members;
    }
}

