/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import java.util.Collections;
import java.util.List;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.DummyExp;
import kd.bos.algo.olap.mdx.calc.ListCalc;
import kd.bos.algo.olap.mdx.calc.Scope;
import kd.bos.algo.olap.mdx.calc.impl.AbstractListCalc;
import kd.bos.algo.olap.mdx.calc.impl.extend.OrderCrossJoinCalc;
import kd.bos.algo.olap.mdx.calc.impl.func.CrossjoinCalc;
import kd.bos.algo.olap.mdx.func.FuncUtil2;

public class OrderCalc
extends AbstractListCalc {
    private final ListCalc listCalc;
    private final Calc expCalc;
    private final boolean desc;
    private final boolean brk;

    public OrderCalc(Exp call, ListCalc listCalc, Calc expCalc, boolean desc, boolean brk) {
        super(call, new Calc[]{listCalc, expCalc});
        this.listCalc = listCalc;
        this.expCalc = expCalc;
        this.desc = desc;
        this.brk = brk;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OlapException {
        Calc calc = super.optimize(scope, evaluator);
        if (calc != this) {
            return calc;
        }
        if (this.listCalc instanceof CrossjoinCalc && !this.brk) {
            CrossjoinCalc cjCalc = (CrossjoinCalc)this.listCalc;
            ListCalc orderCalc = new OrderCalc(new DummyExp(cjCalc.listCalc1.getType()), cjCalc.listCalc1, this.expCalc, this.desc, false);
            orderCalc = (ListCalc)orderCalc.optimize(scope, evaluator);
            OrderCrossJoinCalc orderCJCalc = new OrderCrossJoinCalc(new DummyExp(this.getType()), orderCalc, cjCalc.listCalc2, this.expCalc, this.desc);
            return orderCJCalc;
        }
        return this;
    }

    @Override
    public IList evaluateList(Evaluator evaluator) throws OlapException {
        IList list = this.listCalc.evaluateList(evaluator);
        FuncUtil2.sort(evaluator.push(), list, this.expCalc, this.desc, this.brk);
        return list;
    }

    @Override
    public Calc[] getCalcs() {
        return new Calc[]{this.listCalc, this.expCalc};
    }

    public List getArguments() {
        return Collections.singletonList(this.desc ? (this.brk ? "BDESC" : "DESC") : (this.brk ? "BASC" : "ASC"));
    }
}

