/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.collection.ListFactoryFactory;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.CalcUtil;
import kd.bos.algo.olap.mdx.calc.DummyExp;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.ListCalc;
import kd.bos.algo.olap.mdx.calc.MemberCalc;
import kd.bos.algo.olap.mdx.calc.Scope;
import kd.bos.algo.olap.mdx.calc.TupleCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractListCalc;
import kd.bos.algo.olap.mdx.type.SetType;
import kd.bos.algo.olap.mdx.type.Type;
import kd.bos.algo.olap.mdx.type.TypeUtil;

public class SetCalc
extends AbstractListCalc {
    public SetCalc(Exp exp, Exp[] args, ExpCompiler compiler) throws OlapException {
        super(exp, null);
        this.calcs = this.compileSelf(args, compiler);
    }

    public SetCalc(Exp exp, Calc[] calcs) {
        super(exp, calcs);
        this.calcs = calcs;
    }

    private Calc[] compileSelf(Exp[] args, ExpCompiler compiler) throws OlapException {
        Calc[] calcs = new Calc[args.length];
        for (int i = 0; i < args.length; ++i) {
            calcs[i] = this.createCalc(args[i], compiler);
        }
        return calcs;
    }

    private Calc createCalc(Exp arg, ExpCompiler compiler) throws OlapException {
        Type type = arg.getType();
        if (type instanceof SetType) {
            ListCalc listCalc = compiler.compileList(arg);
            return listCalc;
        }
        if (TypeUtil.couldBeMember(type)) {
            MemberCalc memberCalc = compiler.compileMember(arg);
            return memberCalc;
        }
        TupleCalc tupleCalc = compiler.compileTuple(arg);
        return tupleCalc;
    }

    @Override
    public IList evaluateList(Evaluator evaluator) throws OlapException {
        if (this.calcs.length == 2) {
            IList left = this.toList(evaluator, this.calcs[0].evaluate(evaluator));
            IList right = this.toList(evaluator, this.calcs[1].evaluate(evaluator));
            return ListFactoryFactory.getListFactory().createUnionList(left, right);
        }
        IList result = ListFactoryFactory.getListFactory().createArrayList();
        for (int i = 0; i < this.calcs.length; ++i) {
            if (this.calcs[i] instanceof ListCalc) {
                IList list = ((ListCalc)this.calcs[i]).evaluateList(evaluator);
                result.addList(list);
                continue;
            }
            result.add(this.calcs[i].evaluate(evaluator));
        }
        return result;
    }

    private IList toList(Evaluator evaluator, Object obj) {
        if (obj instanceof IList) {
            return (IList)obj;
        }
        IList result = ListFactoryFactory.getListFactory().createArrayList(1);
        result.add(obj);
        return result;
    }

    public Calc trip(Scope scope) {
        Calc calc = this;
        while (calc.getCalcs().length == 1) {
            Calc inner = calc.getCalcs()[0];
            if (!(inner instanceof ListCalc)) continue;
            if (inner instanceof SetCalc) {
                calc = inner;
                continue;
            }
            return inner;
        }
        return calc;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OlapException {
        if (this.calcs.length == 0) {
            return this;
        }
        for (int i = 0; i < this.calcs.length; ++i) {
            this.calcs[i] = this.calcs[i].optimize(scope, evaluator);
        }
        if (this.calcs.length == 1 && this.calcs[0] instanceof ListCalc) {
            return this.calcs[0];
        }
        if (this.calcs[0] instanceof SetCalc) {
            Type type = this.calcs[0].getType();
            if (this.calcs[1] instanceof MemberCalc || this.calcs[1] instanceof TupleCalc) {
                Calc[] c0s = this.calcs[0].getCalcs();
                Calc[] c1s = new Calc[c0s.length + 1];
                System.arraycopy(c0s, 0, c1s, 0, c0s.length);
                c1s[c1s.length - 1] = this.calcs[1];
                SetCalc newCalc = new SetCalc(new DummyExp(type), c1s);
                Calc[] newCalcs = new Calc[this.calcs.length - 1];
                newCalcs[0] = newCalc;
                System.arraycopy(this.calcs, 2, newCalcs, 1, this.calcs.length - 2);
                return new SetCalc(new DummyExp(type), newCalcs).optimize(scope, evaluator);
            }
            if (this.calcs[1] instanceof SetCalc) {
                Calc[] newCalcs = CalcUtil.makeCalcs(this.calcs[0].getCalcs(), this.calcs[1].getCalcs());
                SetCalc newCalc2 = new SetCalc(new DummyExp(type), newCalcs);
                Calc[] newCalcs2 = new Calc[this.calcs.length - 1];
                newCalcs2[0] = newCalc2;
                System.arraycopy(this.calcs, 2, newCalcs2, 1, this.calcs.length - 2);
                return new SetCalc(new DummyExp(type), newCalcs2).optimize(scope, evaluator);
            }
        }
        return this;
    }

    public boolean isUnionCompatible(Calc calc) {
        return calc instanceof ListCalc || calc instanceof MemberCalc || this.calcs[1] instanceof TupleCalc;
    }
}

