/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import java.util.Iterator;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IMemberList;
import kd.bos.algo.olap.collection.ListFactoryFactory;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.MemberCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractMemberListCalc;

public class SiblingsCalc
extends AbstractMemberListCalc {
    MemberCalc memberCalc;
    private boolean self;

    public SiblingsCalc(Exp exp, MemberCalc memberCalc, boolean self) {
        super(exp, new Calc[]{memberCalc});
        this.memberCalc = memberCalc;
        this.self = self;
    }

    @Override
    public IMemberList evaluateMemberList(Evaluator evaluator) throws OlapException {
        IMemberList siblings;
        Member member = this.memberCalc.evaluateMember(evaluator);
        Member parent = member.getParentMember();
        SchemaReader schemaReader = evaluator.getSchemaReader();
        IMemberList iMemberList = siblings = parent == null ? schemaReader.getHierarchyRootMembers(member.getHierarchy()) : schemaReader.getMemberChildren(parent);
        if (this.self) {
            return siblings;
        }
        IMemberList result = ListFactoryFactory.getListFactory().createMemberList();
        Iterator it = siblings.iterator();
        while (it.hasNext()) {
            Member next = (Member)it.next();
            if (next.equals(member)) continue;
            result.add(next);
        }
        return result;
    }
}

