/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.elementexp;

import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.ExpBase;
import kd.bos.algo.olap.mdx.ExpResolver;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.impl.ConstantCalc;
import kd.bos.algo.olap.mdx.type.DimensionType;
import kd.bos.algo.olap.mdx.type.Type;

public class DimensionExpr
extends ExpBase
implements Exp {
    private final Dimension dimension;

    public DimensionExpr(Dimension dimension) {
        this.dimension = dimension;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String toString() {
        return this.dimension.getUniqueName();
    }

    @Override
    public Type getType() {
        return DimensionType.forDimension(this.dimension);
    }

    @Override
    public Object clone() {
        return new DimensionExpr(this.dimension);
    }

    @Override
    public int getCategory() {
        return 2;
    }

    @Override
    public Calc compile(ExpCompiler compiler) {
        return ConstantCalc.constantDimension(this.dimension);
    }

    @Override
    public Exp resolve(ExpResolver resolver) throws OlapException {
        return this;
    }

    public Object evaluate(Evaluator evaluator) throws OlapException {
        return this.dimension;
    }
}

