/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.elementexp;

import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.ExpBase;
import kd.bos.algo.olap.mdx.ExpResolver;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.impl.ConstantCalc;
import kd.bos.algo.olap.mdx.type.HierarchyType;
import kd.bos.algo.olap.mdx.type.Type;

public class HierarchyExpr
extends ExpBase
implements Exp {
    private final Hierarchy hierarchy;

    public HierarchyExpr(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public String toString() {
        return this.hierarchy.getUniqueName();
    }

    @Override
    public Type getType() {
        return HierarchyType.forHierarchy(this.hierarchy);
    }

    @Override
    public Object clone() {
        return new HierarchyExpr(this.hierarchy);
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public Exp resolve(ExpResolver resolver) throws OlapException {
        return this;
    }

    public Object evaluate(Evaluator evaluator) throws OlapException {
        return this.hierarchy;
    }

    @Override
    public Calc compile(ExpCompiler compiler) {
        return ConstantCalc.constantHierarchy(this.hierarchy);
    }
}

