/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.func;

import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.FunCall;
import kd.bos.algo.olap.mdx.FunDef;
import kd.bos.algo.olap.mdx.FunDefBase;
import kd.bos.algo.olap.mdx.FuncResolver;
import kd.bos.algo.olap.mdx.FunctionException;
import kd.bos.algo.olap.mdx.Literal;
import kd.bos.algo.olap.mdx.MultiFuncResolver;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.LevelCalc;
import kd.bos.algo.olap.mdx.calc.MemberCalc;
import kd.bos.algo.olap.mdx.calc.impl.func.DescendantsCalc;
import kd.bos.algo.olap.mdx.func.FuncUtil2;
import kd.bos.algo.olap.mdx.func.SimpleDescendantsFunDef;
import kd.bos.algo.olap.util.EnumeratedValues;

class DescendantsFunDef
extends FunDefBase {
    private final boolean self;
    private final boolean before;
    private final boolean after;
    private final boolean depthSpecified;
    private final int depthLimit;

    public DescendantsFunDef(FuncResolver resolver, int returnType, int[] parameterTypes, int flag, boolean depthSpecified, int depthLimit) {
        super(resolver, returnType, parameterTypes);
        this.self = FuncUtil2.checkFlag(flag, 1, true);
        this.after = FuncUtil2.checkFlag(flag, 2, true);
        this.before = FuncUtil2.checkFlag(flag, 4, true);
        this.depthSpecified = depthSpecified;
        this.depthLimit = depthLimit;
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        LevelCalc levelCalc = !this.depthSpecified && call.getArgCount() > 1 ? compiler.compileLevel(call.getArg(1)) : null;
        return new DescendantsCalc(call, memberCalc, levelCalc, this.self, this.before, this.after, this.depthSpecified, this.depthLimit);
    }

    static class Resolver
    extends MultiFuncResolver {
        public Resolver() {
            super("Descendants", "Descendants(<Member>[, <Level>[, <Desc_flag>]]|<IncludeSelf Boolean>)", "Returns the set of descendants of a member at a specified level, optionally including or excluding descendants in other levels.", new String[]{"fxm", "fxmb", "fxml", "fxmly", "fxmn", "fxmny"});
        }

        @Override
        protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) throws OlapException {
            int depthLimit = -1;
            boolean depthSpecified = false;
            int flag = 1;
            if (args.length == 1) {
                depthLimit = -1;
                flag = 7;
            }
            if (args.length >= 2 && args[1] instanceof Literal) {
                Literal literal = (Literal)args[1];
                if (literal.getValueObject() instanceof Number) {
                    Number number = (Number)literal.getValueObject();
                    depthLimit = number.intValue();
                    depthSpecified = true;
                } else if (literal.getValueObject() instanceof Boolean) {
                    Boolean includeSelf = (Boolean)literal.getValueObject();
                    return new SimpleDescendantsFunDef(this, returnType, parameterTypes, includeSelf);
                }
            }
            if (args.length >= 3) {
                flag = FuncUtil2.getLiteralArg(args, 2, 1, Flags.instance);
            }
            if (FuncUtil2.checkFlag(flag, 8, true)) {
                throw new FunctionException("Descendants Flag 'Leaves' is not supported now, please use LeafDescendants(<Member>) or Member.LeafDescendants .");
            }
            int depthLimitFinal = depthLimit < 0 ? Integer.MAX_VALUE : depthLimit;
            int flagFinal = flag;
            boolean depthSpecifiedFinal = depthSpecified;
            return new DescendantsFunDef(this, returnType, parameterTypes, flagFinal, depthSpecifiedFinal, depthLimitFinal);
        }

        @Override
        public String[] getReservedWords() {
            return Flags.instance.getNames();
        }
    }

    static class Flags
    extends EnumeratedValues {
        static final Flags instance = new Flags();
        public static final int SELF = 1;
        public static final int AFTER = 2;
        public static final int BEFORE = 4;
        public static final int BEFORE_AND_AFTER = 6;
        public static final int SELF_AND_AFTER = 3;
        public static final int SELF_AND_BEFORE = 5;
        public static final int SELF_BEFORE_AFTER = 7;
        public static final int LEAVES = 8;

        private Flags() {
            super(new String[]{"SELF", "AFTER", "BEFORE", "BEFORE_AND_AFTER", "SELF_AND_AFTER", "SELF_AND_BEFORE", "SELF_BEFORE_AFTER", "LEAVES"}, new int[]{1, 2, 4, 6, 3, 5, 7, 8});
        }
    }
}

