/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.func;

import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.FunCall;
import kd.bos.algo.olap.mdx.FunDef;
import kd.bos.algo.olap.mdx.FunDefBase;
import kd.bos.algo.olap.mdx.FuncResolver;
import kd.bos.algo.olap.mdx.MultiFuncResolver;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.ListCalc;
import kd.bos.algo.olap.mdx.calc.impl.func.OrderCalc;
import kd.bos.algo.olap.mdx.func.FuncUtil2;
import kd.bos.algo.olap.util.EnumeratedValues;

class OrderFunDef
extends FunDefBase {
    public OrderFunDef(FuncResolver resolver, int returnType, int[] parameterTypes, boolean desc, boolean brk) {
        super(resolver, returnType, parameterTypes);
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        Calc expCalc = compiler.compileScalar(call.getArg(1), true);
        int order = FuncUtil2.getLiteralArg(call.getArgs(), 2, 0, Flags.instance);
        boolean desc = Flags.isDescending(order);
        boolean brk = Flags.isBreak(order);
        return new OrderCalc(call, listCalc, expCalc, desc, brk);
    }

    static class Flags
    extends EnumeratedValues {
        static final Flags instance = new Flags();
        public static final int ASC = 0;
        public static final int DESC = 1;
        public static final int BASC = 2;
        public static final int BDESC = 3;

        private Flags() {
            super(new String[]{"ASC", "DESC", "BASC", "BDESC"});
        }

        public static final boolean isDescending(int value) {
            return (value & 1) == 1;
        }

        public static final boolean isBreak(int value) {
            return (value & 2) == 2;
        }
    }

    static class OrderFuncResolver
    extends MultiFuncResolver {
        public OrderFuncResolver() {
            super("Order", "Order(<Set>, <Value Expression>[, ASC | DESC | BASC | BDESC])", "Arranges members of a set, optionally preserving or breaking the hierarchy.", new String[]{"fxxvy", "fxxv"});
        }

        @Override
        public String[] getReservedWords() {
            return Flags.instance.getNames();
        }

        @Override
        protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) throws OlapException {
            int order = FuncUtil2.getLiteralArg(args, 2, 0, Flags.instance);
            boolean desc = Flags.isDescending(order);
            boolean brk = Flags.isBreak(order);
            return new OrderFunDef(this, returnType, parameterTypes, desc, brk);
        }
    }
}

