/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.api.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.elasticsearch.api.impl.AbstractESAction;
import kd.bos.elasticsearch.config.ESConfig;
import kd.bos.elasticsearch.request.AddOrUpdateFieldRequest;
import kd.bos.elasticsearch.request.ESRequest;
import kd.bos.elasticsearch.request.Mapping;
import kd.bos.elasticsearch.response.ESResponse;
import org.elasticsearch.client.RestClient;

class AddOrUpdateFieldAction
extends AbstractESAction<Void> {
    private String index;
    private Mapping mapping;

    public AddOrUpdateFieldAction(ESConfig config, String index, Mapping mapping) {
        super(config);
        this.index = index;
        this.mapping = mapping;
    }

    public AddOrUpdateFieldAction(RestClient restClient, String index, Mapping mapping) {
        super(restClient);
        this.index = index;
        this.mapping = mapping;
    }

    @Override
    protected Void parse(ESResponse esResponse, ESRequest esRequest, Class responseDataCls) {
        return this.retry(esResponse, esRequest, responseDataCls);
    }

    @Override
    protected Class getResponseDataCls() {
        return Void.class;
    }

    @Override
    protected ESRequest build() {
        return new AddOrUpdateFieldRequest(this.index, this.mapping, this.getParameters(), this.getServerVersion());
    }

    private Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("master_timeout", "30s");
        parameters.put("timeout", "600s");
        if (this.getServerVersion() <= 6) {
            parameters.put("include_type_name", "false");
        }
        return parameters;
    }
}

