/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.api.impl;

import java.util.HashMap;
import kd.bos.elasticsearch.api.impl.AbstractESAction;
import kd.bos.elasticsearch.config.ESConfig;
import kd.bos.elasticsearch.request.ESRequest;
import kd.bos.elasticsearch.request.IndexExistRequest;
import kd.bos.elasticsearch.response.ESResponse;
import org.elasticsearch.client.RestClient;

class IndexExistAction
extends AbstractESAction<Boolean> {
    private String index;

    public IndexExistAction(ESConfig config, String index) {
        super(config);
        this.index = index;
    }

    public IndexExistAction(RestClient restClient, String index) {
        super(restClient);
        this.index = index;
    }

    @Override
    protected Boolean parse(ESResponse esResponse, ESRequest esRequest, Class responseDataCls) {
        if (esResponse.getStatusLine() != null && esResponse.getStatusLine().getStatusCode() == 404) {
            return false;
        }
        return true;
    }

    @Override
    protected Class getResponseDataCls() {
        return Void.class;
    }

    @Override
    protected ESRequest build() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ignore_unavailable", "false");
        params.put("expand_wildcards", "open,closed");
        params.put("allow_no_indices", "false");
        if (this.getServerVersion() <= 6) {
            params.put("ignore_throttled", "false");
            params.put("include_type_name", "false");
        }
        return new IndexExistRequest(this.index, params);
    }
}

