/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.api.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.elasticsearch.api.impl.AbstractESAction;
import kd.bos.elasticsearch.config.ESConfig;
import kd.bos.elasticsearch.request.ESRequest;
import kd.bos.elasticsearch.request.Settings;
import kd.bos.elasticsearch.request.UpdateSettingRequest;
import kd.bos.elasticsearch.response.ESResponse;
import org.elasticsearch.client.RestClient;

class UpdateSettingsAction
extends AbstractESAction<Void> {
    private String index;
    private Settings settings;

    public UpdateSettingsAction(ESConfig config, String index, Settings settings) {
        super(config);
        this.index = index;
        this.settings = settings;
    }

    public UpdateSettingsAction(RestClient restClient, String index, Settings settings) {
        super(restClient);
        this.index = index;
        this.settings = settings;
    }

    @Override
    protected Void parse(ESResponse esResponse, ESRequest esRequest, Class responseDataCls) {
        return this.retry(esResponse, esRequest, responseDataCls);
    }

    @Override
    protected Class getResponseDataCls() {
        return Void.class;
    }

    @Override
    protected ESRequest build() {
        return new UpdateSettingRequest(this.index, this.settings, this.getParameters(), this.getServerVersion());
    }

    private Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("master_timeout", "30s");
        parameters.put("timeout", "600s");
        parameters.put("ignore_unavailable", "false");
        parameters.put("expand_wildcards", "open,closed");
        parameters.put("allow_no_indices", "false");
        parameters.put("ignore_throttled", "false");
        return parameters;
    }
}

