/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.elasticsearch.config.ESConfig;
import kd.bos.elasticsearch.factory.ESClientFactory;
import kd.bos.elasticsearch.request.ESRequest;
import kd.bos.elasticsearch.response.ESInfoResponse;
import kd.bos.elasticsearch.response.ESResponse;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class ESRestClient
implements AutoCloseable {
    private RestClient client;
    private int serverVersion;
    protected static final Log logger = LogFactory.getLog((String)"ESRestClient");
    private ESConfig config;

    public ESRestClient(ESConfig config) {
        this.config = config;
        this.init(config);
    }

    public ESRestClient(RestClient client) {
        this.client = client;
        this.initServerVersion();
    }

    public Response execute(Request request) throws IOException {
        return this.client.performRequest(request);
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        ESClientFactory.clearClient(this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ESConfig config) {
        SSLContext sslContext;
        String name = config.getUserName();
        String np = config.getNp();
        String schema = StringUtils.isEmpty((String)config.getSchema()) ? "http" : config.getSchema();
        String certPath = config.getCertPath();
        String certPassword = config.getCertPassword();
        String[] hosts = config.getHosts().split(",");
        HttpHost[] httpHosts = new HttpHost[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            int portIdx = hosts[i].lastIndexOf(":");
            int port = 9200;
            if (portIdx <= 0) continue;
            try {
                port = Integer.parseInt(hosts[i].substring(portIdx + 1));
            }
            catch (NumberFormatException e) {
                logger.error("ESRestClient monitor.es.url parse exception ,check it ", (Throwable)e);
                throw e;
            }
            String ip = hosts[i].substring(0, portIdx);
            httpHosts[i] = new HttpHost(ip, port, schema);
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
        InputStream inputStream = null;
        try {
            if ("https".equals(schema)) {
                if (StringUtils.isEmpty((String)certPath)) {
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy());
                    sslContext = sslContextBuilder.build();
                } else {
                    Path trustStorePath = Paths.get(certPath, new String[0]);
                    KeyStore trustStore = KeyStore.getInstance("pkcs12");
                    certPassword = Encrypters.decode((String)certPassword);
                    inputStream = Files.newInputStream(trustStorePath, new OpenOption[0]);
                    trustStore.load(inputStream, certPassword.toCharArray());
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, null);
                    sslContext = sslContextBuilder.build();
                }
            } else {
                sslContext = null;
            }
        }
        catch (Exception e) {
            sslContext = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        SSLContext fSSLcontext = sslContext;
        if (name != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(name, np));
            builder.setHttpClientConfigCallback(arg_0 -> ESRestClient.lambda$init$0((CredentialsProvider)credentialsProvider, config, fSSLcontext, arg_0));
        } else {
            builder.setHttpClientConfigCallback(rcc -> {
                rcc.disableAuthCaching();
                rcc.setSSLContext(fSSLcontext);
                rcc.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                return rcc;
            });
        }
        builder.setNodeSelector(NodeSelector.SKIP_DEDICATED_MASTERS);
        builder.setRequestConfigCallback(rcc -> {
            rcc.setConnectTimeout(config.getSocketTimeout());
            rcc.setSocketTimeout(config.getQueryTimeout());
            rcc.setConnectionRequestTimeout(config.getConnectionTimeout());
            return rcc;
        });
        this.client = builder.build();
        this.initServerVersion();
    }

    private void initServerVersion() {
        ESResponse esResponse = this.execute(new Request(ESRequest.RequestType.GET.name(), "/"), ESInfoResponse.class);
        String number = ((ESInfoResponse)esResponse.getData()).getVersion().getNumber();
        int index = number.trim().indexOf(".");
        String version = number.substring(0, index);
        this.serverVersion = Integer.parseInt(version);
    }

    private ESResponse execute(Request request, Class responseDataCls) {
        try {
            Response esResponse = this.client.performRequest(request);
            String rspString = null;
            HttpEntity httpEntity = esResponse.getEntity();
            if (httpEntity != null) {
                rspString = EntityUtils.toString((HttpEntity)httpEntity);
            }
            if (esResponse.getStatusLine().getStatusCode() == 200) {
                return new ESResponse(true, "success", null, rspString, null, esResponse.getStatusLine(), esResponse.getHost(), responseDataCls);
            }
            return new ESResponse(false, "fail,status code: " + esResponse.getStatusLine().getStatusCode(), null, rspString, null, esResponse.getStatusLine(), esResponse.getHost(), responseDataCls);
        }
        catch (IOException | IllegalStateException e) {
            logger.error("execute es request error", (Throwable)e);
            if (e instanceof ResponseException) {
                Response response = ((ResponseException)e).getResponse();
                String respString = null;
                try {
                    respString = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return new ESResponse(false, e.getMessage(), e, respString, null, response.getStatusLine(), null, responseDataCls);
            }
            return new ESResponse(false, e.getMessage(), e, null, null, null, null, responseDataCls);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$init$0(CredentialsProvider credentialsProvider, ESConfig config, SSLContext fSSLcontext, HttpAsyncClientBuilder rcc) {
        rcc.setDefaultCredentialsProvider(credentialsProvider);
        rcc.setMaxConnPerRoute(config.getMaxPerRouteConn());
        rcc.setMaxConnTotal(config.getMaxTotalConn());
        rcc.setSSLContext(fSSLcontext);
        rcc.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return rcc;
    }
}

