/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.config;

import java.util.Map;
import kd.bos.util.ConfigurationUtil;

public class ESConfig {
    private String hosts;
    private String userName;
    private String np;
    private String schema;
    private String certPath;
    private String certPassword;
    private static int maxPerRouteConn = 10;
    private static int maxTotalConn = 100;
    private static int socketTimeout = 5000;
    private static int queryTimeout = 300000;
    private static int connectionTimeout = 60000;
    private Map<String, Object> settings;

    public ESConfig(String hosts) {
        this.hosts = hosts;
    }

    public ESConfig(String hosts, String schema) {
        this.hosts = hosts;
        this.schema = schema;
    }

    public ESConfig(String hosts, String userName, String np) {
        this.hosts = hosts;
        this.userName = userName;
        this.np = np;
    }

    public ESConfig(String hosts, String schema, String userName, String np) {
        this.hosts = hosts;
        this.userName = userName;
        this.np = np;
        this.schema = schema;
    }

    public ESConfig(String hosts, String userName, String np, String schema, String certPath, String certPassword) {
        this.hosts = hosts;
        this.userName = userName;
        this.np = np;
        this.schema = schema;
        this.certPath = certPath;
        this.certPassword = certPassword;
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getNp() {
        return this.np;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public String getCertPassword() {
        return this.certPassword;
    }

    public static int getMaxPerRouteConn() {
        return maxPerRouteConn;
    }

    public static int getMaxTotalConn() {
        return maxTotalConn;
    }

    public static int getSocketTimeout() {
        return socketTimeout;
    }

    public static int getQueryTimeout() {
        return queryTimeout;
    }

    public static int getConnectionTimeout() {
        return connectionTimeout;
    }

    public String getKey() {
        return this.hosts + ":" + (this.userName == null ? "" : this.userName) + ":" + (this.schema == null ? "" : this.schema);
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, Object> settings) {
        this.settings = settings;
    }

    static {
        ConfigurationUtil.observeInteger((String)"es.query_timeout", (int)queryTimeout, v -> {
            queryTimeout = v;
        });
        ConfigurationUtil.observeInteger((String)"es.socket_timeout", (int)socketTimeout, v -> {
            socketTimeout = v;
        });
        ConfigurationUtil.observeInteger((String)"es.connection_timeout", (int)connectionTimeout, v -> {
            connectionTimeout = v;
        });
        ConfigurationUtil.observeInteger((String)"es.max_total_conn", (int)maxTotalConn, v -> {
            maxTotalConn = v;
        });
        ConfigurationUtil.observeInteger((String)"es.max_per_route_conn", (int)maxPerRouteConn, v -> {
            maxPerRouteConn = v;
        });
    }
}

