/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.factory;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.elasticsearch.client.BosRestHighLevelClient;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.CheckedConsumer;

public class ElasticSearchFactory {
    private static ConcurrentHashMap<String, RestHighLevelClient> highLevelMap = new ConcurrentHashMap();

    public static RestHighLevelClient getEsClient(String region) {
        return highLevelMap.computeIfAbsent(region, k -> ElasticSearchFactory.getRestHighLevelClient(region));
    }

    private static RestHighLevelClient getRestHighLevelClient(String region) {
        String[] hostArr;
        Map<String, String> configMap = ElasticSearchFactory.getServerConfig(region);
        String userName = configMap.get("username");
        String pwd = configMap.get("password");
        String host = configMap.get("host");
        String schema = configMap.get("schema");
        String certPath = configMap.get("certPath");
        String certPassword = configMap.get("certPassword");
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(3);
        for (String s : hostArr = host.split(",")) {
            String[] ipAndPort = s.split(":");
            hosts.add(new HttpHost(ipAndPort[0], Integer.parseInt(ipAndPort[1]), schema));
        }
        return ElasticSearchFactory.createRestHighLevelClient(hosts.toArray(new HttpHost[hosts.size()]), userName, pwd, schema, certPath, certPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RestHighLevelClient createRestHighLevelClient(HttpHost[] httpHosts, String userName, String password, String schema, String certPath, String certPassword) {
        SSLContext sslContext;
        InputStream inputStream = null;
        try {
            if ("https".equals(schema)) {
                if (StringUtils.isEmpty((String)certPath)) {
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy());
                    sslContext = sslContextBuilder.build();
                } else {
                    Path trustStorePath = Paths.get(certPath, new String[0]);
                    KeyStore trustStore = KeyStore.getInstance("pkcs12");
                    certPassword = Encrypters.decode((String)certPassword);
                    inputStream = Files.newInputStream(trustStorePath, new OpenOption[0]);
                    trustStore.load(inputStream, certPassword.toCharArray());
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadTrustMaterial(trustStore, null);
                    sslContext = sslContextBuilder.build();
                }
            } else {
                sslContext = null;
            }
        }
        catch (Exception e) {
            sslContext = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        SSLContext fSSLcontext = sslContext;
        if (userName != null && password != null) {
            password = Encrypters.decode((String)password);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
            RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts).setMaxRetryTimeoutMillis(ElasticSearchFactory.getEsMaxRetryTimeOut()).setHttpClientConfigCallback(arg_0 -> ElasticSearchFactory.lambda$createRestHighLevelClient$1(fSSLcontext, (CredentialsProvider)credentialsProvider, arg_0)).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(ElasticSearchFactory.getEsConnectTimeOut()).setSocketTimeout(ElasticSearchFactory.getEsSocketTimeOut()));
            RestClient restClient = restClientBuilder.build();
            return new BosRestHighLevelClient(restClient, (CheckedConsumer<RestClient, IOException>)((CheckedConsumer)RestClient::close), Collections.emptyList());
        }
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts).setMaxRetryTimeoutMillis(ElasticSearchFactory.getEsMaxRetryTimeOut()).setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder.disableAuthCaching();
            httpClientBuilder.setSSLContext(fSSLcontext);
            httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            return httpClientBuilder;
        }).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(ElasticSearchFactory.getEsConnectTimeOut()).setSocketTimeout(ElasticSearchFactory.getEsSocketTimeOut()));
        RestClient restClient = restClientBuilder.build();
        return new BosRestHighLevelClient(restClient, (CheckedConsumer<RestClient, IOException>)((CheckedConsumer)RestClient::close), Collections.emptyList());
    }

    private static int getEsConnectTimeOut() {
        return Integer.getInteger("elasticsearch.server.connectTimeOut", 300000);
    }

    private static int getEsSocketTimeOut() {
        return Integer.getInteger("elasticsearch.server.socketTimeOut", 300000);
    }

    private static int getEsMaxRetryTimeOut() {
        return Integer.getInteger("elasticsearch.server.maxRetryTimeOut", 300000);
    }

    public static Map<String, String> getServerConfig(String region) {
        String password;
        String key = "elasticsearch.server." + region;
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((String)value)) {
            throw new KDException(BosErrorCode.bosElasticSearch, new Object[]{key + " the fulltext service is not configured."});
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Properties prop = new Properties();
        StringReader reader = new StringReader(value);
        try {
            prop.load(reader);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.bosElasticSearch, key + " configuration resolution error.", (Throwable)e);
        }
        String host = prop.getProperty("host");
        if (StringUtils.isEmpty((String)host)) {
            String ipStr = prop.getProperty("ip");
            if (StringUtils.isEmpty((String)ipStr)) {
                throw new KDException(BosErrorCode.bosElasticSearch, new Object[]{key + " configuration error: ip or host can't be all empty."});
            }
            result.put("ip", ipStr.trim().toLowerCase());
            String httpPortStr = prop.getProperty("httpport");
            if (StringUtils.isEmpty((String)httpPortStr)) {
                httpPortStr = prop.getProperty("port");
                if (StringUtils.isEmpty((String)httpPortStr)) {
                    throw new KDException(BosErrorCode.bosElasticSearch, new Object[]{key + " configuration error: port or httpport can't be all empty."});
                }
                result.put("port", httpPortStr.trim());
            } else {
                result.put("httpport", httpPortStr.trim());
            }
            String serverPort = prop.getProperty("port");
            if (StringUtils.isNotEmpty((String)serverPort)) {
                result.put("port", httpPortStr.trim());
            }
            host = ipStr + ":" + httpPortStr;
        }
        result.put("host", host.trim().toLowerCase());
        String username = prop.getProperty("username");
        if (username != null) {
            result.put("username", username);
        }
        if ((password = prop.getProperty("password")) != null) {
            result.put("password", password);
        }
        result.put("schema", prop.getProperty("schema", "http"));
        result.put("certPath", prop.getProperty("certPath"));
        result.put("certPassword", prop.getProperty("certPassword"));
        String enableStr = prop.getProperty("enable", "true");
        result.put("enable", enableStr.trim().toLowerCase());
        String indexStr = prop.getProperty("index", region);
        result.put("index", indexStr.trim().toLowerCase());
        String clusterNameStr = prop.getProperty("clustername", "elasticsearch");
        result.put("clustername", clusterNameStr);
        String totalFieldsStr = prop.getProperty("totalfields", String.valueOf(8000));
        result.put("totalfields", totalFieldsStr);
        String shardsNumberStr = prop.getProperty("shardsnumber", String.valueOf(5));
        result.put("shardsnumber", shardsNumberStr);
        String perlicasNumverStr = prop.getProperty("replicasnumber", String.valueOf(2));
        result.put("replicasnumber", perlicasNumverStr);
        return result;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createRestHighLevelClient$1(SSLContext fSSLcontext, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.disableAuthCaching();
        httpClientBuilder.setSSLContext(fSSLcontext);
        httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

