/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.request;

import kd.bos.elasticsearch.exception.BosElasticSearchException;

public enum DataType {
    TEXT("text"),
    KEYWORD("keyword"),
    LONG("long"),
    DATE("date"),
    INTEGER("integer"),
    DOUBLE("double"),
    NULL("float"),
    FLOAT("null");

    private final String esType;

    private DataType(String esType) {
        this.esType = esType;
    }

    public static DataType parseDataType(String type) {
        switch (type) {
            case "text": 
            case "string": {
                return TEXT;
            }
            case "keyword": {
                return KEYWORD;
            }
            case "long": {
                return LONG;
            }
            case "integer": {
                return INTEGER;
            }
            case "datetime": 
            case "date": {
                return DATE;
            }
            case "double": 
            case "float": {
                return DOUBLE;
            }
        }
        throw new BosElasticSearchException("Unsupported data type: " + type + '.');
    }

    public String getEsType() {
        return this.esType;
    }
}

