/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.request;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.elasticsearch.request.ESRequest;

public class DeleteRequest
extends ESRequest {
    public DeleteRequest(String index, List<Object> pks, Map<String, String> params, int esServerVersion, String type) {
        this.endpoint = index + "/_bulk";
        this.data = this.createData(index, pks, esServerVersion, type);
        this.requestType = ESRequest.RequestType.POST;
        this.contentType = ESRequest.ContentType.JSON;
        this.params = params;
    }

    private String createData(String index, List<Object> pks, int esServerVersion, String type) {
        StringBuilder builder = new StringBuilder();
        if (pks != null && pks.size() > 0) {
            for (Object pk : pks) {
                JSONObject deleteJson = new JSONObject();
                JSONObject indexJson = new JSONObject();
                indexJson.put("_index", (Object)index);
                if (esServerVersion <= 6) {
                    indexJson.put("_type", (Object)type);
                }
                indexJson.put("_id", pk);
                deleteJson.put("delete", (Object)indexJson);
                builder.append(deleteJson.toJSONString());
                builder.append("\n");
            }
        }
        return builder.toString();
    }
}

