/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.common.trace;

import java.security.SecureRandom;
import java.util.Random;

public class SdkTraceIdCreator {
    private static Random random = new SecureRandom();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static long createId() {
        return random.nextLong();
    }

    public static String createTraceId() {
        long id = SdkTraceIdCreator.createId();
        String traceId = SdkTraceIdCreator.idToHex(id);
        return traceId;
    }

    public static String idToHex(long id) {
        char[] data = new char[16];
        SdkTraceIdCreator.writeHexLong(data, 0, id);
        return new String(data);
    }

    public static long hexToId(String hexString) {
        int length = hexString.length();
        if (length < 1 || length > 32) {
            throw new IllegalArgumentException("Malformed id: " + hexString);
        }
        int beginIndex = length > 16 ? length - 16 : 0;
        return SdkTraceIdCreator.hexToId(hexString, beginIndex);
    }

    public static long hexToId(String lowerHex, int index) {
        long result = 0L;
        int endIndex = Math.min(index + 16, lowerHex.length());
        while (index < endIndex) {
            char c = lowerHex.charAt(index);
            result <<= 4;
            if (c >= '0' && c <= '9') {
                result |= (long)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                result |= (long)(c - 97 + 10);
            } else {
                throw new IllegalArgumentException("Malformed id: " + lowerHex);
            }
            ++index;
        }
        return result;
    }

    static void writeHexLong(char[] data, int pos, long v) {
        SdkTraceIdCreator.writeHexByte(data, pos + 0, (byte)(v >>> 56 & 0xFFL));
        SdkTraceIdCreator.writeHexByte(data, pos + 2, (byte)(v >>> 48 & 0xFFL));
        SdkTraceIdCreator.writeHexByte(data, pos + 4, (byte)(v >>> 40 & 0xFFL));
        SdkTraceIdCreator.writeHexByte(data, pos + 6, (byte)(v >>> 32 & 0xFFL));
        SdkTraceIdCreator.writeHexByte(data, pos + 8, (byte)(v >>> 24 & 0xFFL));
        SdkTraceIdCreator.writeHexByte(data, pos + 10, (byte)(v >>> 16 & 0xFFL));
        SdkTraceIdCreator.writeHexByte(data, pos + 12, (byte)(v >>> 8 & 0xFFL));
        SdkTraceIdCreator.writeHexByte(data, pos + 14, (byte)(v & 0xFFL));
    }

    static void writeHexByte(char[] data, int pos, byte b) {
        data[pos + 0] = HEX_DIGITS[b >> 4 & 0xF];
        data[pos + 1] = HEX_DIGITS[b & 0xF];
    }
}

