/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.context;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.mservice.common.trace.SdkTraceIdCreator;
import kd.bos.mservice.sdk.util.SdkNetAddressUtils;

public class KdExternalRequestContext
implements Serializable {
    private static final long serialVersionUID = 1480919950594774076L;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static String ip = SdkNetAddressUtils.getLocalIpAddress();
    private static final ThreadLocal<KdExternalRequestContext> current = new ThreadLocal();
    private String traceId;
    private String tenantId;
    private String accountId;
    private String userId;
    private String userName;
    private String clientUrl;
    private String loginIP;
    private String loginTime;

    private KdExternalRequestContext() {
    }

    private static KdExternalRequestContext create(boolean setCurrent) {
        KdExternalRequestContext rc = new KdExternalRequestContext();
        if (setCurrent) {
            KdExternalRequestContext.set(rc);
        }
        return rc;
    }

    public static KdExternalRequestContext create(String tenantId, String accountId, String userId) {
        KdExternalRequestContext rc = KdExternalRequestContext.create(true);
        rc.setTraceId(SdkTraceIdCreator.createTraceId());
        rc.setTenantId(tenantId);
        rc.setAccountId(accountId);
        rc.setUserId(userId);
        rc.setLoginIP(ip);
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        rc.setLoginTime(df.format(new Date()));
        return rc;
    }

    public static KdExternalRequestContext get() {
        return current.get();
    }

    public static void set(KdExternalRequestContext rc) {
        current.set(rc);
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        if (this.tenantId != null) {
            throw new RuntimeException("Can't reset the tenantId.");
        }
        this.tenantId = tenantId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getLoginIP() {
        return this.loginIP;
    }

    public void setLoginIP(String loginIP) {
        this.loginIP = loginIP;
    }

    public String getLoginTime() {
        return this.loginTime;
    }

    public void setLoginTime(String loginTime) {
        this.loginTime = loginTime;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        if (this.accountId != null) {
            throw new RuntimeException("Can't reset the accountId.");
        }
        this.accountId = accountId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        if (this.userId != null) {
            throw new RuntimeException("Can't reset the userId.");
        }
        this.userId = userId;
    }

    public String getClientUrl() {
        if (this.clientUrl == null) {
            this.clientUrl = "";
        }
        return this.clientUrl;
    }

    public void setClientUrl(String clientUrl) {
        this.clientUrl = clientUrl;
    }

    public static void remove() {
        current.remove();
    }
}

