/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;

public class KDNumber {
    private static final String KD_NUMBER_0 = "KDNumber_0";
    private static final String BOS_DATAENTITY = "bos-dataentity";
    private static final String MESSAGE = "num cann't be null";
    private static final String NOT_SUPPORTED = "not supported";
    private static final String MESSAGE1 = "number cann't be null";
    private Number number;

    public KDNumber() {
    }

    public KDNumber(Number num) {
        this.number = num;
    }

    public Number getValue() {
        return this.number;
    }

    private static String getDesciption() {
        return ResManager.loadKDString("nums \u81f3\u5c11\u6709\u4e00\u4e2a\u6570\u503c", KD_NUMBER_0, BOS_DATAENTITY, new Object[0]);
    }

    public static Number sum(Object[] nums) {
        if (nums.length < 1) {
            throw new RuntimeException(KDNumber.getDesciption());
        }
        KDNumber num = new KDNumber((Number)nums[0]);
        for (int i = 1; i < nums.length; ++i) {
            num.add((Number)nums[i]);
        }
        return num.number;
    }

    public static Number avg(Object[] nums) {
        if (nums.length < 1) {
            throw new RuntimeException(ResManager.loadKDString(KDNumber.getDesciption(), KD_NUMBER_0, BOS_DATAENTITY, new Object[0]));
        }
        return new KDNumber((Number)KDNumber.sum((Object[])nums)).divide((Number)Integer.valueOf((int)nums.length)).number;
    }

    public static Number max(Object[] nums) {
        if (nums.length < 1) {
            throw new RuntimeException(KDNumber.getDesciption());
        }
        KDNumber min_num = new KDNumber((Number)nums[0]);
        for (int i = 1; i < nums.length; ++i) {
            KDNumber num = new KDNumber((Number)nums[i]);
            if (min_num.compareTo(num) >= 0) continue;
            min_num = num;
        }
        return min_num.getValue();
    }

    public static Number min(Object[] nums) {
        if (nums.length < 1) {
            throw new RuntimeException(KDNumber.getDesciption());
        }
        KDNumber max_num = new KDNumber((Number)nums[0]);
        for (int i = 1; i < nums.length; ++i) {
            KDNumber num = new KDNumber((Number)nums[i]);
            if (max_num.compareTo(num) <= 0) continue;
            max_num = num;
        }
        return max_num.getValue();
    }

    public KDNumber add(Number num) {
        if (num == null) {
            throw new RuntimeException(MESSAGE);
        }
        if (this.number == null) {
            this.number = num;
        } else if (num instanceof BigDecimal || this.number instanceof BigDecimal) {
            BigDecimal a = this.toDecimal(num);
            BigDecimal b = this.toDecimal(this.number);
            this.number = a.add(b);
        } else if (num instanceof Long || num instanceof BigInteger || this.number instanceof Long) {
            this.number = this.number.longValue() + num.longValue();
        } else if (num instanceof Integer) {
            this.number = this.number.intValue() + num.intValue();
        } else {
            throw new RuntimeException(NOT_SUPPORTED);
        }
        return this;
    }

    public BigDecimal toDecimal() {
        return this.toDecimal(this.number);
    }

    BigDecimal toDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n instanceof Integer || n instanceof BigInteger || n instanceof Long) {
            return new BigDecimal(n.longValue());
        }
        if (n instanceof Double) {
            return BigDecimal.valueOf(n.doubleValue());
        }
        throw new KDException(String.format(ResManager.loadKDString("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b%s", "KDNumber_1", BOS_DATAENTITY, new Object[0]), n.getClass()));
    }

    public KDNumber subtract(Number num) {
        if (num == null) {
            throw new RuntimeException(MESSAGE);
        }
        if (this.number == null) {
            this.number = 0;
        }
        if (num instanceof BigDecimal || this.number instanceof BigDecimal) {
            BigDecimal a = this.toDecimal(num);
            BigDecimal b = this.toDecimal(this.number);
            this.number = b.subtract(a);
        } else if (num instanceof Long || num instanceof BigInteger || this.number instanceof Long) {
            this.number = this.number.longValue() - num.longValue();
        } else if (num instanceof Integer) {
            this.number = this.number.intValue() - num.intValue();
        } else {
            throw new RuntimeException(NOT_SUPPORTED);
        }
        return this;
    }

    public KDNumber multiply(Number num) {
        if (num == null) {
            throw new RuntimeException(MESSAGE);
        }
        if (this.number == null) {
            throw new RuntimeException(MESSAGE1);
        }
        if (num instanceof BigDecimal || this.number instanceof BigDecimal) {
            BigDecimal a = this.toDecimal(num);
            BigDecimal b = this.toDecimal(this.number);
            this.number = b.multiply(a);
        } else if (num instanceof Long || num instanceof BigInteger || this.number instanceof Long) {
            this.number = this.number.longValue() * num.longValue();
        } else if (num instanceof Integer) {
            this.number = this.number.intValue() * num.intValue();
        } else {
            throw new RuntimeException(NOT_SUPPORTED);
        }
        return this;
    }

    public KDNumber divide(Number num) {
        if (num == null) {
            throw new RuntimeException(MESSAGE);
        }
        if (this.number == null) {
            throw new RuntimeException(MESSAGE1);
        }
        if (num instanceof BigDecimal || this.number instanceof BigDecimal) {
            BigDecimal a = this.toDecimal(num);
            BigDecimal b = this.toDecimal(this.number);
            this.number = b.divide(a, 10, RoundingMode.HALF_UP);
        } else if (num instanceof Long || num instanceof BigInteger || this.number instanceof Long) {
            this.number = this.number.longValue() / num.longValue();
        } else if (num instanceof Integer) {
            this.number = this.number.intValue() / num.intValue();
        } else {
            throw new RuntimeException(NOT_SUPPORTED);
        }
        return this;
    }

    public int compareTo(KDNumber num) {
        return this.compareTo(num.getValue());
    }

    public int compareTo(Number num) {
        if (num == null) {
            throw new RuntimeException(MESSAGE);
        }
        if (this.number == null) {
            throw new RuntimeException(MESSAGE1);
        }
        if (num instanceof BigDecimal || this.number instanceof BigDecimal) {
            BigDecimal a = this.toDecimal(num);
            BigDecimal b = this.toDecimal(this.number);
            return b.compareTo(a);
        }
        if (num instanceof Long || num instanceof BigInteger || this.number instanceof Long) {
            return Long.compare(this.number.longValue(), num.longValue());
        }
        if (num instanceof Integer) {
            return Integer.compare(this.number.intValue(), num.intValue());
        }
        throw new RuntimeException(NOT_SUPPORTED);
    }

    public static void main(String[] args) {
        Object[] items = new Object[]{1, new BigDecimal("1.23"), 1232, new BigDecimal("0.1111"), new BigDecimal("0.0000001")};
        Object[] paras = new Object[]{items};
    }
}

