/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.IListSyncFunction;

public final class ListSync {
    public static <SourceT, TargetT> void Sync(List<SourceT> sourceList, List<TargetT> targetList, IListSyncFunction<SourceT, TargetT> syncFunction, boolean callUpdateFuncWhenCreated) {
        if (sourceList == null) {
            throw new IllegalArgumentException("sourceList");
        }
        if (targetList == null) {
            throw new IllegalArgumentException("targetList");
        }
        Object[] targetArray = new Object[targetList.size()];
        targetArray = targetList.toArray(targetArray);
        ArrayList<Integer> indexArray = new ArrayList<Integer>(targetList.size());
        for (int i = 0; i < targetList.size(); ++i) {
            indexArray.add(i);
        }
        for (SourceT sourceItem : sourceList) {
            TargetT targetItem;
            boolean Found = false;
            for (int i = 0; i < targetArray.length; ++i) {
                Object targetItem2 = targetArray[i];
                if (!syncFunction.equals(sourceItem, targetItem2)) continue;
                syncFunction.update(sourceItem, targetItem2);
                if (!indexArray.contains(i)) continue;
                Found = true;
                indexArray.remove((Object)i);
                break;
            }
            if (Found || (targetItem = syncFunction.create(sourceItem)) == null) continue;
            if (callUpdateFuncWhenCreated) {
                syncFunction.update(sourceItem, targetItem);
            }
            syncFunction.add(targetList, targetItem);
        }
        Iterator<Object> iterator = indexArray.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            syncFunction.remove(targetList, targetArray[index], index);
        }
    }
}

