/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.collections.IKeyedCollectionBase;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

@KSObject
public abstract class KeyedCollectionBase<K, V>
extends ArrayList<V>
implements IKeyedCollectionBase<K, V>,
Serializable {
    private static final long serialVersionUID = -2580045900500551520L;
    private transient Map<K, V> dict;
    private boolean caseInsensitive = true;

    public KeyedCollectionBase() {
        this(true);
    }

    public KeyedCollectionBase(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        this.createMap();
    }

    protected KeyedCollectionBase(List<V> list, boolean caseInsensitive) {
        super(list);
        this.caseInsensitive = caseInsensitive;
        this.createMap();
    }

    @Override
    public V set(int index, V element) {
        this.dict.put(this.getItemKey(element), element);
        return super.set(index, element);
    }

    @Override
    public boolean add(V element) {
        this.dict.put(this.getItemKey(element), element);
        return super.add(element);
    }

    @Override
    public void add(int index, V element) {
        this.dict.put(this.getItemKey(element), element);
        super.add(index, element);
    }

    @Override
    public V remove(int index) {
        Object element = super.remove(index);
        this.dict.remove(this.getItemKey(element));
        return (V)element;
    }

    @Override
    public boolean remove(Object element) {
        boolean flag = super.remove(element);
        if (flag) {
            this.dict.remove(this.getItemKey(element));
        }
        return flag;
    }

    @Override
    public void clear() {
        super.clear();
        this.dict.clear();
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        for (V item : c) {
            this.dict.put(this.getItemKey(item), item);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> c) {
        for (V item : c) {
            this.dict.put(this.getItemKey(item), item);
        }
        return super.addAll(index, c);
    }

    public void resetMap() {
        this.createMap();
    }

    private void createMap() {
        this.dict = this.caseInsensitive ? new CaseInsensitiveMap() : new HashMap();
        for (Object local : this) {
            K itemKey = this.getItemKey(local);
            if (itemKey == null) continue;
            this.dict.put(itemKey, local);
        }
    }

    protected abstract K getItemKey(V var1);

    @Override
    @KSMethod
    public boolean containsKey(K key) {
        return this.dict.containsKey(key);
    }

    @Override
    public V get(K key) {
        return this.dict.get(key);
    }

    private void readObject(ObjectInputStream in) {
        try {
            in.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            throw new OrmException("CollectionWithParent.readObject.ClassNotFoundException", e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OrmException("CollectionWithParent.readObject.IOException", e.getMessage(), e);
        }
        this.createMap();
    }
}

