/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.entity;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDirtyProperty;
import kd.bos.dataentity.metadata.IGeoPointProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DataEntityPropertyChangedEventArgs;
import kd.bos.dataentity.utils.StringUtils;

public final class BoolDataEntityState
extends DataEntityState {
    private static final long serialVersionUID = -4830865708467289020L;
    private DataEntityPropertyCollection _properties;
    private BitSet _dirtyArray;

    public BoolDataEntityState() {
    }

    public BoolDataEntityState(DataEntityPropertyCollection properties, BitSet dirtyArray) {
        assert (properties != null);
        assert (dirtyArray != null);
        this._properties = properties;
        this._dirtyArray = dirtyArray;
    }

    public BitSet getDirtyFlag() {
        return this._dirtyArray;
    }

    @Override
    public void setPropertyChanged(PropertyChangeEvent e) {
        DataEntityPropertyChangedEventArgs e2 = (DataEntityPropertyChangedEventArgs)(e instanceof DataEntityPropertyChangedEventArgs ? e : null);
        if (e2 == null) {
            if (e == null || StringUtils.isBlank(e.getPropertyName())) {
                return;
            }
            IDataEntityProperty property = null;
            RefObject<Object> tempRef_property = new RefObject<Object>(property);
            boolean tempVar = this._properties.tryGetValue(e.getPropertyName(), tempRef_property);
            property = (IDataEntityProperty)tempRef_property.argvalue;
            if (tempVar) {
                this._dirtyArray.set(property.getOrdinal(), true);
                if (property instanceof ISimpleProperty) {
                    this.setBizChanged(property.getOrdinal(), true);
                }
            }
        } else if (!e2.getIsErrorRaise()) {
            this._dirtyArray.set(e2.getProperty().getOrdinal(), true);
            if (e2.getProperty() instanceof ISimpleProperty) {
                this.setBizChanged(e2.getProperty().getOrdinal(), true);
            }
        }
    }

    @Override
    public boolean getDataEntityDirty() {
        for (int i = 0; i < this._dirtyArray.length(); ++i) {
            if (!this._dirtyArray.get(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDirty(boolean newValue) {
        this._dirtyArray.set(0, this._properties.size(), newValue);
    }

    @Override
    public void setDirty(ISimpleProperty prop, boolean newValue) {
        this._dirtyArray.set(prop.getOrdinal(), newValue);
    }

    @Override
    public List<IDataEntityProperty> GetDirtyProperties() {
        return this.GetDirtyProperties(false);
    }

    @Override
    public List<IDataEntityProperty> GetDirtyProperties(boolean includehasDefault) {
        int count;
        ArrayList<IDataEntityProperty> list = new ArrayList<IDataEntityProperty>();
        IDataEntityProperty prop = null;
        int n = count = includehasDefault ? this._properties.size() : this._dirtyArray.length();
        if (count > this._properties.size()) {
            count = this._properties.size();
        }
        for (int i = 0; i < count; ++i) {
            prop = (IDataEntityProperty)this._properties.get(i);
            boolean bDirty = this._dirtyArray.get(i);
            if (prop instanceof IGeoPointProperty) {
                IGeoPointProperty gProp = (IGeoPointProperty)prop;
                boolean bl = bDirty = this._dirtyArray.get(gProp.getLatitudeProperty().getOrdinal()) || this._dirtyArray.get(gProp.getLongitudeProperty().getOrdinal());
            }
            if (bDirty || includehasDefault && prop.hasDefaultValue()) {
                list.add(prop);
                continue;
            }
            if (!(prop instanceof IDirtyProperty) || !((IDirtyProperty)((Object)prop)).isDirty()) continue;
            list.add(prop);
        }
        return list;
    }

    @Override
    public Iterable<IDataEntityProperty> getBizChangedProperties() {
        ArrayList<IDataEntityProperty> list = new ArrayList<IDataEntityProperty>();
        IDataEntityProperty prop = null;
        int count = this._bizChanged.length();
        if (count > this._properties.size()) {
            count = this._properties.size();
        }
        for (int i = 1; i < count; ++i) {
            prop = (IDataEntityProperty)this._properties.get(i);
            if (!this._bizChanged.get(i)) continue;
            list.add(prop);
        }
        return list;
    }

    @Override
    public long[] getDirtyFlags() {
        int n = this._dirtyArray.length();
        if (n <= 0) {
            return new long[0];
        }
        return this._dirtyArray.toLongArray();
    }

    @Override
    public void setDirtyFlags(long[] values) {
        this._dirtyArray = BitSet.valueOf(values);
    }
}

