/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.IObjectWithParent;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.exception.OrmException;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DataEntityCollection<T>
extends ArrayList<T>
implements ISupportInitialize,
Serializable {
    private static final long serialVersionUID = -392038235856288403L;
    protected Object parent;
    private transient boolean initializing;

    public DataEntityCollection() {
    }

    public DataEntityCollection(Object parent) {
        this.parent = parent;
    }

    public DataEntityCollection(Object parent, List<T> list) {
        super(list);
        this.parent = parent;
    }

    public final Object getParent() {
        return this.parent;
    }

    @Override
    public boolean add(T item) {
        this.add(this.size(), item);
        return true;
    }

    @Override
    public void add(int index, T item) {
        IObjectWithParent op;
        if (item == null) {
            throw new IllegalArgumentException("item");
        }
        super.add(index, item);
        if (!this.initializing && this.parent != null && (op = (IObjectWithParent)(item instanceof IObjectWithParent ? item : null)) != null) {
            op.setParent(this.parent);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean result = super.addAll(index, c);
        if (result && !this.initializing && this.parent != null) {
            for (T item : c) {
                IObjectWithParent op = (IObjectWithParent)(item instanceof IObjectWithParent ? item : null);
                if (op == null || op.getParent() != null) continue;
                op.setParent(this.parent);
            }
        }
        return result;
    }

    @Override
    public T remove(int index) {
        Object item = super.remove(index);
        IObjectWithParent op = (IObjectWithParent)(item instanceof IObjectWithParent ? item : null);
        if (op != null) {
            op.setParent(null);
        }
        return (T)item;
    }

    @Override
    public T set(int index, T item) {
        T oldItem = super.set(index, item);
        IObjectWithParent op = (IObjectWithParent)(oldItem instanceof IObjectWithParent ? oldItem : null);
        if (op != null) {
            op.setParent(null);
        }
        if ((op = (IObjectWithParent)(item instanceof IObjectWithParent ? item : null)) != null) {
            op.setParent(this.parent);
        }
        return oldItem;
    }

    @Override
    public void clear() {
        for (Object item : this) {
            IObjectWithParent op = (IObjectWithParent)(item instanceof IObjectWithParent ? item : null);
            if (op == null) continue;
            op.setParent(null);
        }
        super.clear();
    }

    @Override
    public boolean isInitialized() {
        return !this.initializing;
    }

    @Override
    public void beginInit() {
        this.initializing = true;
    }

    @Override
    public void endInit() {
        if (this.initializing) {
            this.resetAllParent();
            this.initializing = false;
        }
    }

    private void resetAllParent() {
        if (this.parent != null) {
            for (Object item : this) {
                IObjectWithParent op = (IObjectWithParent)(item instanceof IObjectWithParent ? item : null);
                if (op == null) continue;
                op.setParent(this.parent);
            }
        }
    }

    private void readObject(ObjectInputStream in) {
        try {
            in.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            throw new OrmException("DataEntityCollection.readObject.ClassNotFoundException", e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OrmException("DataEntityCollection.readObject.IOException", e.getMessage(), e);
        }
        this.resetAllParent();
    }
}

