/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DataEntityReference;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;

public final class DataEntityReferenceList
extends ArrayList<DataEntityReference> {
    private static final long serialVersionUID = -3314078787849194718L;
    private static final String STRING = "??????";
    private static final String BOS_DATAENTITY = "bos-dataentity";
    private ConcurrentHashMap<Object, DataEntityReference> _dict;
    private String _dataEntityTypeName;
    private IDataEntityType privateDataEntityType;

    public DataEntityReferenceList(IDataEntityType dataEntityType) {
        if (dataEntityType == null) {
            throw new ORMArgInvalidException(STRING, ResManager.loadKDString("\u6784\u9020\u5b9e\u4f53\u5f15\u7528\u5217\u8868DataEntityReferenceList\u5931\u8d25\uff0c\u6784\u9020\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", "DataEntityReferenceList_0", BOS_DATAENTITY, new Object[0]));
        }
        this.setDataEntityType(dataEntityType);
        this._dict = new ConcurrentHashMap();
    }

    public DataEntityReferenceList(String dataEntityTypeName) {
        if (StringUtils.isEmpty(dataEntityTypeName)) {
            throw new ORMArgInvalidException(STRING, ResManager.loadKDString("\u6784\u9020\u5b9e\u4f53\u5f15\u7528\u5217\u8868DataEntityReferenceList\u5931\u8d25\uff0c\u6784\u9020\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", "DataEntityReferenceList_0", BOS_DATAENTITY, new Object[0]));
        }
        this._dataEntityTypeName = dataEntityTypeName;
        this._dict = new ConcurrentHashMap();
    }

    public String getDataEntityTypeName() {
        if (this._dataEntityTypeName == null && this.getDataEntityType() != null) {
            return this.getDataEntityType().getName();
        }
        return this._dataEntityTypeName;
    }

    public IDataEntityType getDataEntityType() {
        return this.privateDataEntityType;
    }

    private void setDataEntityType(IDataEntityType value) {
        this.privateDataEntityType = value;
    }

    @Override
    public boolean add(DataEntityReference item) {
        this.addToDictionary(item);
        return super.add(item);
    }

    @Override
    public void add(int index, DataEntityReference item) {
        this.addToDictionary(item);
        super.add(index, item);
    }

    private void addToDictionary(DataEntityReference item) {
        if (item == null) {
            throw new ORMArgInvalidException(STRING, ResManager.loadKDString("\u6dfb\u52a0\u5b9e\u4f53\u5931\u8d25,\u8bd5\u56fe\u5f80\u5f15\u7528\u5217\u8868DataEntityReferenceList\u4e2d\u6dfb\u52a0\u7a7a\u5b9e\u4f53\uff01", "DataEntityReferenceList_1", BOS_DATAENTITY, new Object[0]));
        }
        if (item.getOid() == null) {
            throw new ORMArgInvalidException(STRING, ResManager.loadKDString("\u6dfb\u52a0\u5b9e\u4f53\u5931\u8d25,\u8bd5\u56fe\u5f80\u5f15\u7528\u5217\u8868DataEntityReferenceList\u4e2d\u6dfb\u52a0\u4e3b\u952e\u503c\u4e3a\u7a7a\u7684\u5b9e\u4f53\uff01", "DataEntityReferenceList_2", BOS_DATAENTITY, new Object[0]));
        }
        this._dict.put(item.getOid(), item);
    }

    public DataEntityReference addId(Object oid) {
        if (oid == null) {
            throw new ORMArgInvalidException(STRING, ResManager.loadKDString("\u6dfb\u52a0\u5b9e\u4f53\u5931\u8d25,\u8bd5\u56fe\u5f80\u5f15\u7528\u5bf9\u8c61DataEntityReference\u4e2d\u6dfb\u52a0\u7a7a\u5b9e\u4f53\uff01", "DataEntityReferenceList_3", BOS_DATAENTITY, new Object[0]));
        }
        DataEntityReference item = this._dict.get(oid);
        if (item == null) {
            item = new DataEntityReference(oid);
            this.add(item);
        }
        return item;
    }

    @Override
    public void clear() {
        super.clear();
        this._dict.clear();
    }

    public boolean TryGet(Object oid, RefObject<DataEntityReference> item) {
        if (oid == null) {
            item.argvalue = null;
            return false;
        }
        DataEntityReference o = this._dict.get(oid);
        if (o == null) {
            item.argvalue = null;
            return false;
        }
        item.argvalue = o;
        return true;
    }

    public boolean contains(DataEntityReference item) {
        if (item == null || item.getOid() == null) {
            return false;
        }
        return this._dict.containsKey(item.getOid());
    }

    public Object[] GetOids() {
        Object[] array = new Object[this.size()];
        int i = 0;
        for (DataEntityReference item : this) {
            array[i] = item.getOid();
            ++i;
        }
        return array;
    }

    public Object[] GetNotLoadedOids() {
        ArrayList<Object> list = new ArrayList<Object>(this._dict.size());
        for (DataEntityReference item : this) {
            if (item.getIsDataEntityLoaded()) continue;
            list.add(item.getOid());
        }
        return list.toArray(new Object[0]);
    }

    public List<DataEntityReference> getNotLoadedTasks() {
        ArrayList<DataEntityReference> list = new ArrayList<DataEntityReference>();
        for (DataEntityReference item : this) {
            if (item.getIsDataEntityLoaded()) continue;
            list.add(item);
        }
        return list;
    }

    @Override
    public boolean remove(Object o) {
        DataEntityReference item = (DataEntityReference)o;
        if (item == null || item.getOid() == null) {
            return false;
        }
        this._dict.remove(item.getOid());
        return super.remove(o);
    }
}

