/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.entity;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataStorage;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LongDataStorage;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.DataEntityCacheType;
import kd.bos.dataentity.metadata.DataEntityTypeFlag;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DataEntityPropertyChangedEventArgs;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DynamicObjectSerializer;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@JsonSerialize(using=DynamicObjectSerializer.class)
@KSObject
@SdkPublic
public class DynamicObject
extends DataEntityBase
implements Serializable {
    private static final long serialVersionUID = 4259350041532815092L;
    private static final String STRING = "??????";
    private static final String BOS_DATAENTITY = "bos-dataentity";
    private static final String SPAN_TYPE_DYNAMICOBJECT = "DynamicObject";
    private DynamicObjectType dt;
    private IDataStorage dataStorage;
    private transient BitSet lastDirty;
    private boolean isQueryObj;
    private transient DataEntityCacheType localCacheType = null;

    public BitSet getLastDirty() {
        if (this.lastDirty == null) {
            this.lastDirty = new BitSet();
        }
        return this.lastDirty;
    }

    @Override
    public void OnPropertyChanged(PropertyChangeEvent e) {
        this.getLastDirty().set(((DataEntityPropertyChangedEventArgs)e).getProperty().getOrdinal(), true);
        super.OnPropertyChanged(e);
    }

    public DynamicObject() {
    }

    public DynamicObject(DynamicObjectType dt, Object id) {
        if (dt == null) {
            throw new ORMArgInvalidException(STRING, ResManager.loadKDString("\u6784\u9020\u52a8\u6001\u5b9e\u4f53\u5931\u8d25\uff0c\u6784\u9020\u53c2\u6570\uff1a\u5b9e\u4f53\u7c7b\u578bdt\u4e0d\u80fd\u4e3a\u7a7a!", "DynamicObject_0", BOS_DATAENTITY, new Object[0]));
        }
        if (dt.getFlag() == DataEntityTypeFlag.Abstract) {
            throw new ORMArgInvalidException(STRING, String.format(ResManager.loadKDString("\u6784\u9020\u52a8\u6001\u5b9e\u4f53\u5931\u8d25\uff0c{0}\u4e3a\u62bd\u8c61\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u88ab\u5b9e\u4f8b\u5316\uff01", "DynamicObject_1", BOS_DATAENTITY, new Object[0]), dt.getName()));
        }
        if (dt.getFlag() == DataEntityTypeFlag.Interface) {
            throw new ORMArgInvalidException(STRING, String.format(ResManager.loadKDString("\u6784\u9020\u52a8\u6001\u5b9e\u4f53\u5931\u8d25\uff0c{0}\u4e3a\u63a5\u53e3\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u88ab\u5b9e\u4f8b\u5316\uff01", "DynamicObject_2", BOS_DATAENTITY, new Object[0]), dt.getName()));
        }
        this.dt = dt;
        this.dataStorage = Boolean.getBoolean("dynamicobject.longdatastorage") ? new LongDataStorage(this.dt) : new ArrayStorage(this.dt);
        if (id != null) {
            dt.getPrimaryKey().setValue(this, id);
        }
    }

    public DynamicObject(DynamicObjectType dt) {
        this(dt, null);
    }

    public DynamicObject(DynamicObjectType dt, boolean isQueryObj) {
        this(dt, null);
        this.isQueryObj = isQueryObj;
    }

    @KSMethod
    public final DynamicObjectType getDynamicObjectType() {
        return this.dt;
    }

    @Override
    @KSMethod
    public IDataEntityType getDataEntityType() {
        return this.dt;
    }

    @SdkInternal
    public final IDataStorage getDataStorage() {
        return this.dataStorage;
    }

    @SdkInternal
    public final void setDataStorage(IDataStorage value) {
        this.dataStorage = value;
    }

    protected IDataStorage createDataStorage() {
        return new ArrayStorage(this.dt);
    }

    @KSMethod
    public final void set(String propertyName, Object value) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProperties().get(propertyName);
        if (dp != null) {
            dp.setValueFast(this, value);
            return;
        }
        if (propertyName.indexOf(46) == -1 && propertyName.lastIndexOf(93) == -1) {
            dp = (IDataEntityProperty)this.dt.getProperties().get(propertyName);
            if (dp == null) {
                String msg = String.format(ResManager.loadKDString("\u5b9e\u4f53\u7c7b\u578b%1$s\u4e2d\u4e0d\u5b58\u5728\u540d\u4e3a%2$s\u7684\u5c5e\u6027", "DynamicObject_3", BOS_DATAENTITY, new Object[0]), this.dt.getName(), propertyName);
                if (this.dt.getParent() != null) {
                    IDataEntityType mainEntity = null;
                    try {
                        mainEntity = this.findMainEntity(this.dt);
                    }
                    catch (Exception e) {
                        msg = msg + e.getMessage();
                    }
                    if (mainEntity != null) {
                        msg = String.format(ResManager.loadKDString("\u4e3b\u5b9e\u4f53\u7c7b\u578b%1$s\u7684\u5b9e\u4f53\u7c7b\u578b%2$s\u4e2d\u4e0d\u5b58\u5728\u540d\u4e3a%3$s\u7684\u5c5e\u6027", "DynamicObject_4", BOS_DATAENTITY, new Object[0]), mainEntity.getName(), this.dt.getName(), propertyName);
                    }
                }
                ORMDesignException e = new ORMDesignException(STRING, msg);
                HashMap<String, Object> tags = new HashMap<String, Object>(3);
                tags.put("err.prop", propertyName);
                tags.put("err.value", value);
                tags.put("err.dt", this.dt);
                EntityTracer.throwException(SPAN_TYPE_DYNAMICOBJECT, "set", null, e, tags);
                throw e;
            }
            dp.setValueFast(this, value);
        } else {
            this.setPropertyPathValue(propertyName, value);
        }
    }

    @KSMethod
    public final void set(int index, Object value) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProperties().get(index);
        dp.setValue(this, value);
    }

    @KSMethod
    public final void set(IDataEntityProperty dp, Object value) {
        if (dp == null) {
            throw new IllegalArgumentException("property");
        }
        dp.setValue(this, value);
    }

    @KSMethod
    public final Object get(String propertyName) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProperties().get(propertyName);
        if (dp != null) {
            return ObjectConverter.convert(dp.getValueFast(this), dp.getPropertyType(), dp.isEnableNull());
        }
        if (propertyName.indexOf(46) == -1 && propertyName.lastIndexOf(93) == -1) {
            dp = (IDataEntityProperty)this.dt.getProperties().get(propertyName);
            if (dp == null) {
                for (IDataEntityProperty p : this.dt.getProperties()) {
                    if (p.getName() == null || !p.getName().equals(propertyName)) continue;
                    dp = p;
                    break;
                }
            }
            if (dp == null) {
                ORMDesignException e = new ORMDesignException(STRING, String.format(ResManager.loadKDString("\u5b9e\u4f53\u7c7b\u578b%1$s\u4e2d\u4e0d\u5b58\u5728\u540d\u4e3a%2$s\u7684\u5c5e\u6027", "DynamicObject_3", BOS_DATAENTITY, new Object[0]), this.dt.getName(), propertyName));
                HashMap<String, Object> tags = new HashMap<String, Object>(2);
                tags.put("err.prop", propertyName);
                tags.put("err.dt", this.dt);
                EntityTracer.throwException(SPAN_TYPE_DYNAMICOBJECT, "get", null, e, tags);
                throw e;
            }
            return ObjectConverter.convert(dp.getValueFast(this), dp.getPropertyType(), dp.isEnableNull());
        }
        return this.getPropertyPathValue(propertyName);
    }

    @KSMethod
    public final Object get(int index) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProperties().get(index);
        return ObjectConverter.convert(dp.getValueFast(this), dp.getPropertyType(), dp.isEnableNull());
    }

    @KSMethod
    public final boolean containsProperty(String propertyName) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProperties().get(propertyName);
        return dp != null;
    }

    @KSMethod
    public final Object get(IDataEntityProperty dp) {
        if (dp == null) {
            throw new IllegalArgumentException("property");
        }
        return ObjectConverter.convert(dp.getValueFast(this), dp.getPropertyType(), dp.isEnableNull());
    }

    @Deprecated
    @SdkInternal
    public final Object getItem(String propertyName) {
        return this.get(propertyName);
    }

    @Deprecated
    @SdkInternal
    public final Object getItem(int index) {
        return this.get(index);
    }

    @Deprecated
    @SdkInternal
    public final Object getItem(IDataEntityProperty dp) {
        return this.get(dp);
    }

    @Deprecated
    @SdkInternal
    public final void setItem(String propertyName, Object value) {
        this.set(propertyName, value);
    }

    @Deprecated
    @SdkInternal
    public final void setItem(int index, Object value) {
        this.set(index, value);
    }

    @Deprecated
    @SdkInternal
    public final void setItem(IDataEntityProperty dp, Object value) {
        this.set(dp, value);
    }

    private <T> T get(String propertyName, Class<T> cls) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProperties().get(propertyName);
        if (dp == null) {
            for (IDataEntityProperty p : this.dt.getProperties()) {
                if (p.getName() == null || !p.getName().equals(propertyName)) continue;
                dp = p;
                break;
            }
        }
        if (dp != null) {
            Object value = dp.getValueFast(this);
            if (value != null && cls.isAssignableFrom(value.getClass())) {
                return (T)value;
            }
            return ObjectConverter.convert(value, cls, dp.isEnableNull());
        }
        return ObjectConverter.convert(this.get(propertyName), cls, dp != null ? dp.isEnableNull() : false);
    }

    private <T> T get(int index, Class<T> cls) {
        IDataEntityProperty dp = (IDataEntityProperty)this.dt.getProperties().get(index);
        return ObjectConverter.convert(this.get(index), cls, dp != null ? dp.isEnableNull() : false);
    }

    private <T> T get(IDataEntityProperty dp, Class<T> cls) {
        Object value = this.get(dp);
        if (value == null) {
            return null;
        }
        return (T)(cls.isAssignableFrom(value.getClass()) ? value : ObjectConverter.convert(value, cls, dp.isEnableNull()));
    }

    @KSMethod
    public String getString(String propertyName) {
        return this.get(propertyName, String.class);
    }

    public String getString(int index) {
        return this.get(index, String.class);
    }

    public String getString(IDataEntityProperty dp) {
        return this.get(dp, String.class);
    }

    @KSMethod
    public ILocaleString getLocaleString(String propertyName) {
        return this.get(propertyName, ILocaleString.class);
    }

    public ILocaleString getLocaleString(int index) {
        return this.get(index, ILocaleString.class);
    }

    public ILocaleString getLocaleString(IDataEntityProperty dp) {
        return this.get(dp, ILocaleString.class);
    }

    @KSMethod
    public int getInt(String propertyName) {
        return this.get(propertyName, Integer.class);
    }

    public int getInt(int index) {
        return this.get(index, Integer.class);
    }

    public int getInt(IDataEntityProperty dp) {
        return this.get(dp, Integer.class);
    }

    @KSMethod
    public long getLong(String propertyName) {
        return this.get(propertyName, Long.class);
    }

    public long getLong(int index) {
        return this.get(index, Long.class);
    }

    public long getLong(IDataEntityProperty dp) {
        return this.get(dp, Long.class);
    }

    @KSMethod
    public boolean getBoolean(String propertyName) {
        return this.get(propertyName, Boolean.class);
    }

    public boolean getBoolean(int index) {
        return this.get(index, Boolean.class);
    }

    public boolean getBoolean(IDataEntityProperty dp) {
        return this.get(dp, Boolean.class);
    }

    @KSMethod
    public BigDecimal getBigDecimal(String propertyName) {
        return this.get(propertyName, BigDecimal.class);
    }

    @KSMethod
    public BigDecimal getBigDecimal(String propertyName, boolean enableNull) {
        if (enableNull && ((IDataEntityProperty)this.dt.getProperties().get(propertyName)).getValueFast(this) == null) {
            return null;
        }
        return this.get(propertyName, BigDecimal.class);
    }

    public BigDecimal getBigDecimal(int index) {
        return this.get(index, BigDecimal.class);
    }

    public BigDecimal getBigDecimal(IDataEntityProperty dp) {
        return this.get(dp, BigDecimal.class);
    }

    @KSMethod
    public Date getDate(String propertyName) {
        return this.get(propertyName, Date.class);
    }

    public Date getDate(int index) {
        return this.get(index, Date.class);
    }

    public Date getDate(IDataEntityProperty dp) {
        return this.get(dp, Date.class);
    }

    @KSMethod
    public DynamicObject getDynamicObject(String propertyName) {
        return this.get(propertyName, DynamicObject.class);
    }

    public DynamicObject getDynamicObject(int index) {
        return this.get(index, DynamicObject.class);
    }

    public DynamicObject getDynamicObject(IDataEntityProperty dp) {
        return this.get(dp, DynamicObject.class);
    }

    @KSMethod
    public DynamicObjectCollection getDynamicObjectCollection(String propertyName) {
        return this.get(propertyName, DynamicObjectCollection.class);
    }

    public DynamicObjectCollection getDynamicObjectCollection(int index) {
        return this.get(index, DynamicObjectCollection.class);
    }

    public DynamicObjectCollection getDynamicObjectCollection(IDataEntityProperty dp) {
        return this.get(dp, DynamicObjectCollection.class);
    }

    private void setPropertyPathValue(String propertyPath, Object value) {
        int dot = propertyPath.lastIndexOf(46);
        String path = propertyPath.substring(0, dot);
        Object obj = this.getPropertyPathValue(path);
        if (obj == null) {
            throw new IllegalArgumentException("Porperty " + path + " is empty.");
        }
        String propertyName = propertyPath.substring(dot + 1);
        if (obj instanceof DynamicObject) {
            ((DynamicObject)obj).set(propertyName, value);
        } else if (obj instanceof Map) {
            ((Map)obj).put(propertyName, value);
        } else {
            String m1 = propertyName.toLowerCase();
            String m2 = "set" + m1;
            try {
                for (Method method : obj.getClass().getMethods()) {
                    String name;
                    if (method.getParameterCount() != 1 || !(name = method.getName().toLowerCase(Locale.ENGLISH)).equals(m1) && !name.equals(m2)) continue;
                    method.setAccessible(true);
                    method.invoke(obj, value);
                    return;
                }
                for (AccessibleObject accessibleObject : obj.getClass().getFields()) {
                    if (!((Field)accessibleObject).getName().toLowerCase(Locale.ENGLISH).equals(m1)) continue;
                    ((Field)accessibleObject).setAccessible(true);
                    ((Field)accessibleObject).set(obj, value);
                    return;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(obj.getClass() + " set property failed: " + propertyName, e);
            }
            throw new IllegalArgumentException("Porperty " + path + " not found.");
        }
    }

    private Object getPropertyPathValue(String propertyPath) {
        String[] segs = propertyPath.split("\\.");
        Object obj = this;
        for (String seg : segs) {
            obj = this.getPropertyValue(obj, seg);
        }
        return obj;
    }

    private Object getPropertyValue(Object obj, String propertyName) {
        if (obj == null) {
            return null;
        }
        int index = -1;
        int s1 = propertyName.indexOf("[");
        if (s1 != -1) {
            String s;
            int s2 = propertyName.indexOf("]");
            if (s1 != -1 && s2 > s1 && (s = propertyName.substring(s1 + 1, s2)).matches("\\d+")) {
                index = Integer.parseInt(s);
            }
            if (index == -1) {
                throw new IllegalArgumentException("Porperty incorrect: " + propertyName);
            }
        }
        if (index == -1) {
            if (obj instanceof DynamicObject) {
                return ((DynamicObject)obj).get(propertyName);
            }
            if (obj instanceof Map) {
                return ((Map)obj).get(propertyName);
            }
            String m1 = propertyName.toLowerCase();
            String m2 = "get" + m1;
            String m3 = "is" + m1;
            try {
                for (Method method : obj.getClass().getMethods()) {
                    String name;
                    if (method.getParameterCount() != 0 || !(name = method.getName().toLowerCase(Locale.ENGLISH)).equals(m1) && !name.equals(m2) && !name.equals(m3)) continue;
                    method.setAccessible(true);
                    return method.invoke(obj, new Object[0]);
                }
                for (AccessibleObject accessibleObject : obj.getClass().getFields()) {
                    if (!((Field)accessibleObject).getName().toLowerCase(Locale.ENGLISH).equals(m1)) continue;
                    ((Field)accessibleObject).setAccessible(true);
                    return ((Field)accessibleObject).get(obj);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(obj.getClass() + " get property failed: " + propertyName, e);
            }
        } else if ((obj = this.getPropertyValue(obj, propertyName.substring(0, s1))) != null) {
            if (obj instanceof List) {
                return ((List)obj).get(index);
            }
            throw new IllegalArgumentException(obj.getClass() + " property is not a list: " + propertyName);
        }
        return null;
    }

    public String toString() {
        return this.dt.toString() + this.dataStorage.toString();
    }

    public boolean isQueryObj() {
        return this.isQueryObj;
    }

    private IDataEntityType findMainEntity(IDataEntityType dt) {
        if (dt == null) {
            return null;
        }
        IDataEntityType parentDt = dt.getParent();
        if (parentDt != null && parentDt.getParent() != null) {
            return this.findMainEntity(parentDt);
        }
        return parentDt;
    }

    public void setShared(boolean value) {
        this.localCacheType = value ? DataEntityCacheType.Share : DataEntityCacheType.Multi;
    }

    public boolean isShared() {
        return this.localCacheType != null && this.localCacheType == DataEntityCacheType.Share;
    }

    @Override
    public void endInit() {
        super.endInit();
        this.localCacheType = null;
    }

    class ArrayStorage
    implements IDataStorage,
    Serializable {
        private static final long serialVersionUID = -3756715846844096480L;
        private Object[] values;

        private ArrayStorage() {
        }

        private ArrayStorage(Object[] values) {
            this.values = values;
        }

        public ArrayStorage(DynamicObjectType dt) {
            this.values = new Object[dt.getProperties().size()];
        }

        @Override
        public Object getLocalValue(IDataEntityProperty property) {
            int index = property.getOrdinal();
            if (index >= this.values.length) {
                this.ensureCapacity(property);
            }
            return this.values[index];
        }

        private void ensureCapacity(IDataEntityProperty property) {
            int newSize = property.getOrdinal();
            this.values = Arrays.copyOf(this.values, newSize + 1);
        }

        @Override
        public void setLocalValue(IDataEntityProperty property, Object value) {
            int index = property.getOrdinal();
            if (index >= this.values.length) {
                this.ensureCapacity(property);
            }
            if (EntityTracer.isRealtime()) {
                try (EntityTraceSpan span = EntityTracer.create("IDataStorage", "setLocalValue", EntityTraceHint.getHintDisLinkAPM());){
                    span.addLocaleTag("property", property);
                    span.addLocaleTag("old", this.values[index]);
                    span.addLocaleTag("value", value);
                    span.fireEvent("before");
                }
            }
            this.values[index] = value;
        }

        @Override
        public IDataStorage memberClone() {
            Object[] newValues = new Object[this.values.length];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            for (int i = 0; i < newValues.length; ++i) {
                if (!(newValues[i] instanceof ILocaleValue)) continue;
                newValues[i] = null;
            }
            return new ArrayStorage(newValues);
        }

        public ArrayStorage clone() {
            ArrayStorage varCopy = new ArrayStorage(this.values);
            return varCopy;
        }

        public String toString() {
            return Arrays.asList(this.values).toString();
        }
    }
}

