/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DataEntityCollection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.entity.IEntryReader;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.script.annotations.KSMethod;
import kd.bos.util.JVMMemoryUsage;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DynamicObjectCollection
extends DataEntityCollection<DynamicObject>
implements Serializable {
    private static final long serialVersionUID = 6104399182398478008L;
    private static final String STRING = "??????";
    private static final String BOS_DATAENTITY = "bos-dataentity";
    private static final String SPAN_TYPE_DATACOLL = "DynamicObjectCollection";
    private static final String SPAN_TAG_DT = "dt.name";
    private static final String PARAM_ROWS_SIZE = "rows.size";
    private static final String SPAN_LTAG_ROOTDATAENTITY = "rootDataEntity";
    private static final String SPAN_LTAG_DT = "dt";
    private static final String SPAN_LTAG_ENTRY_ROWS = "entry.rows";
    private static final String PARAM_ROWINDEX = "rowIndex";
    private static final String PARAM_OBJ = "obj";
    private List<DynamicObject> deleteRows;
    private DynamicObjectType dt;
    private String dtFullName;
    private boolean isInitializing = false;
    private long memoryStatsTime;
    private long mayBeAddedRows = 0L;
    private static IEntryReader entryReader;
    private static final long reservedMinMemory = 20L;
    private static final long reservedMemory = 50L;
    private static final long reservedMaybeObjectMaxSize = 1024L;

    public DynamicObjectCollection() {
    }

    public DynamicObjectCollection(DynamicObjectType dt, Object parent) {
        super(parent);
        if (dt == null) {
            throw new ORMArgInvalidException(STRING, ResManager.loadKDString("\u6784\u9020\u5b9e\u4f53\u96c6\u5408DynamicObjectCollection\u5931\u8d25\uff0c\u6784\u9020\u53c2\u6570:\u660e\u7ec6\u7c7b\u578bdynamicItemPropertyType\u4e0d\u80fd\u4e3a\u7a7a\uff01", "DynamicObjectCollection_0", BOS_DATAENTITY, new Object[0]));
        }
        this.dt = dt;
    }

    public DynamicObjectCollection(DynamicObjectType dynamicItemPropertyType, Object parent, List<DynamicObject> list) {
        super(parent, list);
        if (dynamicItemPropertyType == null) {
            throw new ORMArgInvalidException(STRING, ResManager.loadKDString("\u6784\u9020\u5b9e\u4f53\u96c6\u5408DynamicObjectCollection\u5931\u8d25\uff0c\u6784\u9020\u53c2\u6570:\u660e\u7ec6\u7c7b\u578bdynamicItemPropertyType\u4e0d\u80fd\u4e3a\u7a7a\uff01", "DynamicObjectCollection_0", BOS_DATAENTITY, new Object[0]));
        }
        this.dt = dynamicItemPropertyType;
    }

    @Deprecated
    public final DynamicObjectType getDynamicCollectionItemPropertyType() {
        return this.getDynamicObjectType();
    }

    @KSMethod
    public final DynamicObjectType getDynamicObjectType() {
        return this.dt;
    }

    @KSMethod
    public DynamicObject addNew() {
        DynamicObject item = (DynamicObject)this.dt.createInstance();
        super.add(item);
        return item;
    }

    @Override
    @KSMethod
    public void add(int index, DynamicObject item) {
        Throwable throwable;
        EntityTraceSpan span;
        if (EntityTracer.isRealtime()) {
            span = EntityTracer.create(SPAN_TYPE_DATACOLL, "add", new EntityTraceHint(false));
            throwable = null;
            try {
                this.addCommonTag(span);
                span.addTag(PARAM_ROWINDEX, String.valueOf(index));
                span.addLocaleTag(PARAM_OBJ, item);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span != null) {
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        span.close();
                    }
                }
            }
        }
        if (this.dt != null) {
            if (!this.dt.getName().equals(item.getDynamicObjectType().getName()) || !this.dt.getExtendName().equals(item.getDynamicObjectType().getExtendName())) {
                span = EntityTracer.create(SPAN_TYPE_DATACOLL, "add", new EntityTraceHint(false));
                throwable = null;
                try {
                    try {
                        ORMArgInvalidException e = new ORMArgInvalidException(STRING, ResManager.loadKDString("\u6dfb\u52a0\u884c\u5230DynamicObjectCollection\u5931\u8d25\uff0c\u6570\u636e\u884c\u7c7b\u578b\u4e0e\u96c6\u5408\u7c7b\u578b\u4e0d\u5339\u914d\uff01", "DynamicObjectCollection_1", BOS_DATAENTITY, new Object[0]));
                        span.addLocaleTag("this.dt", this.dt);
                        span.addLocaleTag("item.dt", item.getDataEntityType());
                        span.throwException(e);
                        throw e;
                    }
                    catch (Throwable e) {
                        throwable = e;
                        throw e;
                    }
                }
                catch (Throwable throwable4) {
                    if (span != null) {
                        if (throwable != null) {
                            try {
                                span.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            span.close();
                        }
                    }
                    throw throwable4;
                }
            }
            if (this.size() > 200000) {
                long rowLength = this.dt.getEstimatedRowLen() + 20L;
                long intervalTime = this.mayBeAddedRows * rowLength / 1024L / 1024L * 100L;
                if (this.mayBeAddedRows == 0L || System.currentTimeMillis() - this.memoryStatsTime > intervalTime) {
                    long leftMemory = JVMMemoryUsage.getLeftMemory_MB();
                    long freeMem = (leftMemory - 20L) * 1024L * 1024L;
                    this.mayBeAddedRows = freeMem / rowLength;
                    this.memoryStatsTime = System.currentTimeMillis();
                    if (leftMemory < 20L || leftMemory < 50L && this.mayBeAddedRows < 30000L || this.mayBeAddedRows == 0L) {
                        throw new OrmException("bos-exception", "DynamicObjectCollection exceed max memory limit");
                    }
                }
                --this.mayBeAddedRows;
            }
        } else {
            this.dt = item.getDynamicObjectType();
            this.parent = item.getParent();
        }
        super.add(index, item);
    }

    @Override
    @KSMethod
    public boolean addAll(Collection<? extends DynamicObject> c) {
        long leftMemory;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create(SPAN_TYPE_DATACOLL, "addAll", new EntityTraceHint(false));){
                this.addCommonTag(span);
                span.addTag(PARAM_ROWS_SIZE, String.valueOf(c.size()));
                span.addLocaleTag(PARAM_OBJ, c);
            }
        }
        if (this.size() + c.size() > 200000 && ((leftMemory = JVMMemoryUsage.getLeftMemory_MB()) < 20L || leftMemory < 50L && c.size() < 30000)) {
            throw new OrmException("bos-exception", "DynamicObjectCollection exceed max memory limit");
        }
        return super.addAll(c);
    }

    public final List<DynamicObject> getDeleteRows() {
        if (this.deleteRows == null) {
            this.deleteRows = new ArrayList<DynamicObject>();
        }
        return this.deleteRows;
    }

    public final List<DynamicObject> getInsertRows() {
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>();
        for (DynamicObject o : this) {
            if (o.getDataEntityState().getFromDatabase()) continue;
            rows.add(o);
        }
        return rows;
    }

    public final List<DynamicObject> getUpdateRows() {
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>();
        for (DynamicObject o : this) {
            if (!o.getDataEntityState().getFromDatabase() || !o.getDataEntityState().getDataEntityDirty()) continue;
            rows.add(o);
        }
        return rows;
    }

    @Override
    public DynamicObject remove(int index) {
        DynamicObject o;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create(SPAN_TYPE_DATACOLL, "remove", new EntityTraceHint(false));){
                this.addCommonTag(span);
                span.addTag(PARAM_ROWINDEX, String.valueOf(index));
            }
        }
        if ((o = (DynamicObject)this.get(index)).getDataEntityState().getFromDatabase()) {
            this.getDeleteRows().add(o);
            this.getRootEntity().getDataEntityState().setRemovedItems(true);
        }
        this.reduceRowCount();
        return (DynamicObject)super.remove(index);
    }

    public DynamicObject getRootEntity() {
        DynamicObject parent = (DynamicObject)this.getParent();
        if (parent == null) {
            return null;
        }
        DynamicObject grandpa = (DynamicObject)parent.getParent();
        if (grandpa != null) {
            return grandpa;
        }
        return parent;
    }

    public DynamicObjectType getRootEntityType() {
        DynamicObjectType parent = (DynamicObjectType)this.getDynamicObjectType().getParent();
        if (parent == null) {
            return null;
        }
        DynamicObjectType grandpa = (DynamicObjectType)parent.getParent();
        if (grandpa != null) {
            return grandpa;
        }
        return parent;
    }

    @Override
    public boolean remove(Object obj) {
        DynamicObject o;
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create(SPAN_TYPE_DATACOLL, "remove", new EntityTraceHint(false));){
                this.addCommonTag(span);
                span.addTag(PARAM_OBJ, "DynamicObject");
                span.addLocaleTag(PARAM_OBJ, obj);
            }
        }
        if ((o = (DynamicObject)obj).getDataEntityState().getFromDatabase()) {
            this.getDeleteRows().add(o);
            DynamicObject root = this.getRootEntity();
            if (root != null) {
                root.getDataEntityState().setRemovedItems(true);
            }
        }
        this.reduceRowCount();
        return super.remove(o);
    }

    @Override
    public void clear() {
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create(SPAN_TYPE_DATACOLL, "clear", new EntityTraceHint(false));){
                this.addCommonTag(span);
            }
        }
        if (!this.isInitializing) {
            this.recordClearAction();
        }
        super.clear();
    }

    @SdkInternal
    protected void recordClearAction() {
        if (!this.isInitializing) {
            for (DynamicObject o : this) {
                if (!o.getDataEntityState().getFromDatabase()) continue;
                this.getDeleteRows().add(o);
            }
            if (this.getDeleteRows().size() > 0) {
                this.getRootEntity().getDataEntityState().setRemovedItems(true);
            }
        }
    }

    @SdkInternal
    protected boolean isInitializing() {
        return this.isInitializing;
    }

    public void setStartRowIndex(int rowIndex) {
        ((DataEntityBase)this.getParent()).getDataEntityState().setEntryStartRowIndex(this.dt.getName(), rowIndex);
    }

    public int getStartRowIndex() {
        return ((DataEntityBase)this.getParent()).getDataEntityState().getEntryStartRowIndex(this.dt.getName());
    }

    public void setRowCount(int rowCount) {
        ((DataEntityBase)this.getParent()).getDataEntityState().setEntryRowCount(this.dt.getName(), rowCount);
    }

    private void reduceRowCount() {
        if (this.getParent() == null) {
            return;
        }
        Integer rowCount = ((DataEntityBase)this.getParent()).getDataEntityState().getEntryRowCount(this.dt.getName());
        if (rowCount != null) {
            Integer n = rowCount;
            Integer n2 = rowCount = Integer.valueOf(rowCount - 1);
            this.setRowCount(n);
        }
    }

    public int getRowCount() {
        EntryInfo entryInfo = ((DataEntityBase)this.getParent()).getDataEntityState().getEntryInfo(this.dt.getName());
        if (entryInfo == null || entryInfo.getRowCount() == null) {
            return this.size();
        }
        if (entryInfo.getStartRowIndex() + entryInfo.getPageSize() >= entryInfo.getRowCount()) {
            return entryInfo.getStartRowIndex() + this.size();
        }
        return entryInfo.getRowCount() + this.size() - entryInfo.getPageSize();
    }

    public int getPageCount() {
        return this.getRowCount() / this.getPageSize() + 1;
    }

    public int getPageIndex() {
        return this.getStartRowIndex() / this.getPageSize() + 1;
    }

    public int getPageSize() {
        return ((DataEntityBase)this.getParent()).getDataEntityState().getEntryPageSize(this.dt.getName());
    }

    private IEntryReader geEntryReader() {
        if (entryReader == null) {
            entryReader = (IEntryReader)TypesContainer.createInstance("kd.bos.orm.dataentity.EntryReader");
        }
        return entryReader;
    }

    public void fetchEntryRows(int pageIndex) {
        this.isInitializing = true;
        int startRows = (pageIndex - 1) * this.getPageSize();
        this.geEntryReader().fetchEntryRows(this, startRows, this.getPageSize());
        this.isInitializing = false;
    }

    public void fetchEntryRows(int stratRowIndex, int pageSize) {
        this.isInitializing = true;
        ((DataEntityBase)this.getParent()).getDataEntityState().setEntryPageSize(this.dt.getName(), pageSize);
        this.geEntryReader().fetchEntryRows(this, stratRowIndex, this.getPageSize());
        this.isInitializing = false;
    }

    private String getDTFullName() {
        if (this.dtFullName == null) {
            StringBuilder sBuilder = new StringBuilder();
            String sp = "";
            for (IDataEntityType pdt = this.dt; pdt != null; pdt = pdt.getParent()) {
                sBuilder.insert(0, pdt.getName() + sp);
                sp = ".";
            }
            this.dtFullName = sBuilder.toString();
        }
        return this.dtFullName;
    }

    private void addCommonTag(EntityTraceSpan span) {
        span.addTag(SPAN_TAG_DT, this.getDTFullName());
        span.addLocaleTag(SPAN_LTAG_ROOTDATAENTITY, this.getParent());
        span.addLocaleTag(SPAN_LTAG_DT, this.dt);
        span.addLocaleTag(SPAN_LTAG_ENTRY_ROWS, this.size());
    }
}

