/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.IListSyncFunction;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class LocaleDynamicObjectCollection
extends DynamicObjectCollection {
    private static final long serialVersionUID = 5222216356341046508L;
    private IDataEntityProperty _localeIdProperty;
    private static String Key_LocaleId = "LocaleId";

    public LocaleDynamicObjectCollection() {
    }

    public LocaleDynamicObjectCollection(DynamicObjectType itemDt, Object parent) {
        super(itemDt, parent);
        this._localeIdProperty = itemDt.getProperty(Key_LocaleId);
    }

    @Override
    @KSMethod
    public void add(int index, DynamicObject item) {
        super.add(index, item);
        if (this._localeIdProperty == null) {
            this._localeIdProperty = this.getDynamicObjectType().getProperty(Key_LocaleId);
        }
    }

    public IDataEntityProperty getLocaleIdProperty() {
        return this._localeIdProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject getOrCreateItemByLocaleId(String localeId) {
        RefObject<Object> row = new RefObject<Object>(null);
        if (this.findByLocaleId(localeId, row)) {
            return (DynamicObject)row.argvalue;
        }
        LocaleDynamicObjectCollection localeDynamicObjectCollection = this;
        synchronized (localeDynamicObjectCollection) {
            if (this.findByLocaleId(localeId, row)) {
                return (DynamicObject)row.argvalue;
            }
            row.argvalue = (DynamicObject)this.getDynamicObjectType().createInstance();
            this._localeIdProperty.setValue(row.argvalue, localeId);
            this.add(row.argvalue);
            return (DynamicObject)row.argvalue;
        }
    }

    public boolean findByLocaleId(String localeId, RefObject<DynamicObject> obj) {
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            obj.argvalue = this.get(i);
            if (!localeId.equals(this._localeIdProperty.getValueFast(obj.argvalue))) continue;
            return true;
        }
        obj = null;
        return false;
    }

    public void setValue(IDataEntityProperty inLocalProperty, String localeId, Object newValue) {
        if (StringUtils.isBlank((String)newValue)) {
            RefObject<Object> obj = new RefObject<Object>(null);
            if (this.findByLocaleId(localeId, obj)) {
                inLocalProperty.setValue(obj.argvalue, null);
            }
        } else {
            DynamicObject obj = this.getOrCreateItemByLocaleId(localeId);
            inLocalProperty.setValue(obj, newValue);
        }
    }

    public void setValue(final DynamicProperty inLocalProperty, ILocaleString values) {
        IListSyncFunction<Map.Entry<String, String>, DynamicObject> syncFunction = new IListSyncFunction<Map.Entry<String, String>, DynamicObject>(){

            @Override
            public boolean equals(Map.Entry<String, String> s, DynamicObject t) {
                return s.getKey().equals(LocaleDynamicObjectCollection.this._localeIdProperty.getValueFast(t));
            }

            @Override
            public void update(Map.Entry<String, String> s, DynamicObject t) {
                inLocalProperty.setValue(t, s.getValue());
            }

            @Override
            public DynamicObject create(Map.Entry<String, String> s) {
                if (StringUtils.isBlank(s.getValue())) {
                    return null;
                }
                DynamicObject row = (DynamicObject)LocaleDynamicObjectCollection.this.getDynamicCollectionItemPropertyType().createInstance();
                LocaleDynamicObjectCollection.this._localeIdProperty.setValue(row, s.getKey());
                return row;
            }

            @Override
            public void add(List<DynamicObject> col, DynamicObject item) {
                col.add(item);
            }

            @Override
            public void remove(List<DynamicObject> col, DynamicObject t, int index) {
                inLocalProperty.resetDTValue(t);
            }
        };
        ArrayList entrys = new ArrayList(values.size());
        for (Map.Entry entry : values.entrySet()) {
            if ("GLang".equals(entry.getKey())) continue;
            entrys.add(entry);
        }
        OrmUtils.sync(entrys, this, syncFunction, true);
        this.removeEmpty();
    }

    public void clearValue(IDataEntityProperty inLocalProperty) {
        for (int i = this.size() - 1; i >= 0; --i) {
            DynamicObject obj = (DynamicObject)this.get(i);
            inLocalProperty.setValue(obj, null);
        }
    }

    public boolean removeIfEmpty(DynamicObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException("obj");
        }
        DynamicObjectType dt = this.getDynamicCollectionItemPropertyType();
        int pkIndex = this._localeIdProperty.getOrdinal();
        if (dt.getPrimaryKey() != null) {
            pkIndex = dt.getPrimaryKey().getOrdinal();
        }
        int localeIdIndex = this._localeIdProperty.getOrdinal();
        for (IDataEntityProperty property : dt.getProperties()) {
            if (property.getOrdinal() == pkIndex || property.getOrdinal() == localeIdIndex || StringUtils.isBlank((String)property.getValueFast(obj))) continue;
            return false;
        }
        return this.remove(obj);
    }

    public void removeEmpty() {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.removeIfEmpty((DynamicObject)this.get(i));
        }
    }

    public Object getValue(IDataEntityProperty inLocalProperty, String localeId) {
        RefObject<Object> refobj = new RefObject<Object>(null);
        if (this.findByLocaleId(localeId, refobj)) {
            return inLocalProperty.getValueFast(refobj.argvalue);
        }
        return null;
    }

    public Object getCurrentLocaleValue(IDataEntityProperty inLocalProperty) {
        String localeId = Lang.get().toString();
        return this.getValue(inLocalProperty, localeId);
    }

    public void setCurrentLocaleValue(IDataEntityProperty inLocalProperty, Object newValue) {
        String localeId = Lang.get().toString();
        this.setValue(inLocalProperty, localeId, newValue);
    }

    public static Object createLocaleValue(LocaleDynamicObjectCollection col, DynamicSimpleProperty inLocaleProperty) {
        return new OrmLocaleValue(col, inLocaleProperty);
    }
}

