/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.entity;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class OrmLocaleValue
implements ILocaleString,
Serializable {
    private static final long serialVersionUID = -9019668015463680553L;
    private LocaleDynamicObjectCollection _col;
    private IDataEntityProperty _inLocalProperty;
    private String glValue = "";

    @Override
    @KSMethod
    public String getLocaleValue() {
        return ILocaleString.super.getLocaleValue();
    }

    public OrmLocaleValue(LocaleDynamicObjectCollection col, DynamicSimpleProperty inLocaleProperty) {
        this._col = col;
        this._inLocalProperty = inLocaleProperty;
    }

    @Override
    public String getItem(String lcid) {
        if (lcid.equals("GLang")) {
            return this.glValue;
        }
        return (String)this._col.getValue(this._inLocalProperty, lcid);
    }

    @Override
    public void setItem(String lcid, String value) {
        if (lcid.equals("GLang")) {
            this.glValue = value;
            return;
        }
        this._col.setValue(this._inLocalProperty, lcid, value);
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        RefObject<Object> obj = new RefObject<Object>(null);
        return this._col.findByLocaleId((String)key, obj);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public String get(Object key) {
        return this.getItem((String)key);
    }

    @Override
    public String put(String key, String value) {
        this.setItem(key, value);
        return value;
    }

    @Override
    public String remove(Object key) {
        if (StringUtils.equals("GLang", String.valueOf(key))) {
            String oValue = this.glValue;
            this.glValue = "";
            return oValue;
        }
        String v = this.getItem((String)key);
        this._col.setValue(this._inLocalProperty, (String)key, null);
        return v;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            this.setItem(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this._col.clearValue(this._inLocalProperty);
        this.glValue = "";
    }

    @Override
    public Set<String> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public Collection<String> values() {
        return this.getMap().values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.getMap().entrySet();
    }

    private Map<String, String> getMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank(this.glValue)) {
            map.put("GLang", this.glValue);
        }
        if (this._col.size() > 0) {
            DynamicProperty lcProp = this._col.getDynamicObjectType().getProperty("LocaleId");
            for (DynamicObject o : this._col) {
                map.put((String)lcProp.getValueFast(o), (String)this._inLocalProperty.getValueFast(o));
            }
        }
        return map;
    }

    public String toString() {
        String val = this.getDefaultItem();
        return val == null ? this.get("zh_CN") : val;
    }

    @Override
    public String getDefaultItem() {
        String lcv = this.get(Lang.get().toString());
        if (StringUtils.isNotBlank(lcv)) {
            return lcv;
        }
        if (StringUtils.isNotBlank(this.glValue)) {
            return this.glValue;
        }
        return null;
    }
}

