/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.message;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.message.PushMessageType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PushMessage
implements Serializable {
    private static final long serialVersionUID = 1469255826804646428L;
    private String id = UUID.randomUUID().toString();
    private PushMessageRange range;
    private PushMessageType type = PushMessageType.FormCommand;
    private String from;
    private String to;
    private ZonedDateTime createTime = ZonedDateTime.now();
    private Map<String, String> properties = new HashMap<String, String>();
    private Object body;

    public PushMessage(PushMessageRange range, String to, Object body) {
        this.range = range;
        this.to = to;
        this.body = body;
    }

    public PushMessage(String id, PushMessageRange range, PushMessageType type, String from, String to, ZonedDateTime createTime, Map<String, String> properties, Object body) {
        this.id = id;
        this.range = range;
        this.type = type;
        this.from = from;
        this.to = to;
        this.createTime = createTime;
        this.properties = properties;
        this.body = body;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PushMessageRange getRange() {
        return this.range;
    }

    public void setRange(PushMessageRange range) {
        this.range = range;
    }

    public PushMessageType getType() {
        return this.type;
    }

    public void setType(PushMessageType type) {
        this.type = type;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public ZonedDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(ZonedDateTime createTime) {
        this.createTime = createTime;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public String toString() {
        return String.format("websocketMessage id:%s range:%s to:%s body:%s type:%s", new Object[]{this.id, this.range, this.to, this.body, this.type});
    }
}

