/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.message;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.message.PushMessageType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PushMessageBuilder {
    private String id;
    private PushMessageRange range = PushMessageRange.RootPage;
    private PushMessageType type = PushMessageType.FormCommand;
    private String from;
    private String to;
    private ZonedDateTime createTime;
    private Map<String, String> properties = new HashMap<String, String>();
    private Object body;

    public static PushMessageBuilder create() {
        return new PushMessageBuilder();
    }

    public PushMessageBuilder id(String id) {
        this.id = id;
        return this;
    }

    public PushMessageBuilder range(PushMessageRange range) {
        this.range = range;
        return this;
    }

    public PushMessageBuilder type(PushMessageType type) {
        this.type = type;
        return this;
    }

    public PushMessageBuilder from(String from) {
        this.from = from;
        return this;
    }

    public PushMessageBuilder to(String to) {
        this.to = to;
        return this;
    }

    public PushMessageBuilder createTime(ZonedDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    public PushMessageBuilder setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public PushMessageBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public PushMessageBuilder body(Object body) {
        this.body = body;
        return this;
    }

    public PushMessage build() {
        return new PushMessage(this.id, this.range, this.type, this.from, this.to, this.createTime, this.properties, this.body);
    }
}

