/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.metadata.clr;

import java.beans.PropertyDescriptor;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class CollectionProperty
extends DataEntityProperty
implements ICollectionProperty {
    private IDataEntityType itemType;

    public CollectionProperty(PropertyDescriptor propertyInfo, int ordinal) {
        super(propertyInfo, ordinal);
        CollectionPropertyAttribute cpAtt = propertyInfo.getReadMethod().getAnnotation(CollectionPropertyAttribute.class);
        this.name = !cpAtt.name().isEmpty() ? cpAtt.name() : propertyInfo.getReadMethod().getName().substring(3);
        if (!cpAtt.displayName().isEmpty()) {
            this.displayName = new LocaleString(cpAtt.displayName());
        }
        this.init(cpAtt.collectionItemPropertyType());
    }

    private void init(Class<?> itemType) {
        this.itemType = DataEntityType.getDataEntityType(itemType);
    }

    @Override
    public IDataEntityType getItemType() {
        return this.itemType;
    }

    @Override
    public boolean isEmpty(Object dataEntity) {
        Object items = this.getValue(dataEntity);
        if (items == null) {
            return true;
        }
        if (items instanceof Object[]) {
            Object[] objs = (Object[])items;
            if (objs.length == 0) {
                return true;
            }
            for (Object item : objs) {
                if (this.itemType.isEmpty(item)) continue;
                return false;
            }
        }
        return true;
    }
}

