/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.metadata.clr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.collections.KeyedCollectionBase;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DataEntityPropertyCollection
extends KeyedCollectionBase<String, IDataEntityProperty>
implements Serializable {
    private static final long serialVersionUID = 9071133689422325226L;
    protected IDataEntityType owner;
    private int bitSize = 0;
    private int otherSize = 0;

    protected DataEntityPropertyCollection() {
    }

    @SdkInternal
    public DataEntityPropertyCollection(List<IDataEntityProperty> list, IDataEntityType owner, boolean propertyNameCaseInsensitive) {
        super(list, propertyNameCaseInsensitive);
        this.owner = owner;
    }

    public IDataEntityType getParent() {
        return this.owner;
    }

    @SdkInternal
    public boolean tryGetValue(String propertyName, RefObject<IDataEntityProperty> ref_property) {
        IDataEntityProperty prop = (IDataEntityProperty)this.get(propertyName);
        if (prop == null) {
            return false;
        }
        ref_property.argvalue = prop;
        return true;
    }

    @Override
    protected String getItemKey(IDataEntityProperty item) {
        return item.getName();
    }

    public List<ISimpleProperty> getSimpleProperties(boolean onlyDbProperty) {
        ArrayList<ISimpleProperty> retList = new ArrayList<ISimpleProperty>(this.size());
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ISimpleProperty sp;
            IDataEntityProperty p = (IDataEntityProperty)this.get(i);
            ISimpleProperty iSimpleProperty = sp = p instanceof ISimpleProperty ? (ISimpleProperty)p : null;
            if (sp == null || onlyDbProperty && p.isDbIgnore()) continue;
            retList.add(sp);
        }
        return retList;
    }

    public List<IComplexProperty> getComplexProperties(boolean onlyDbProperty) {
        ArrayList<IComplexProperty> retList = new ArrayList<IComplexProperty>(10);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            IComplexProperty cp;
            IDataEntityProperty p = (IDataEntityProperty)this.get(i);
            IComplexProperty iComplexProperty = cp = p instanceof IComplexProperty ? (IComplexProperty)p : null;
            if (cp == null || onlyDbProperty && p.isDbIgnore()) continue;
            retList.add(cp);
        }
        return retList;
    }

    public List<ICollectionProperty> getCollectionProperties(boolean onlyDbProperty) {
        ArrayList<ICollectionProperty> retList = new ArrayList<ICollectionProperty>(2);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            IDataEntityProperty p = (IDataEntityProperty)this.get(i);
            if (!(p instanceof ICollectionProperty) || onlyDbProperty && p.isDbIgnore()) continue;
            retList.add((ICollectionProperty)p);
        }
        return retList;
    }

    @SdkInternal
    public boolean tryFind(IDataEntityProperty property, int predictedIndex, RefObject<IDataEntityProperty> find) {
        if (this.tryFindPrivate(property, predictedIndex, find)) {
            return true;
        }
        int predictedIndex2 = property.getOrdinal();
        if (predictedIndex2 != predictedIndex && this.tryFindPrivate(property, predictedIndex2, find)) {
            return true;
        }
        return this.tryGetValue(property.getName(), find);
    }

    private boolean tryFindPrivate(IDataEntityProperty property, int predictedIndex, RefObject<IDataEntityProperty> find) {
        IDataEntityProperty v;
        if (predictedIndex >= 0 && predictedIndex < this.size() && ((v = (IDataEntityProperty)this.get(predictedIndex)) == property || v.getName().equalsIgnoreCase(property.getName()))) {
            find.argvalue = v;
            return true;
        }
        return false;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public int getOtherSize() {
        return this.otherSize;
    }

    public void setBitSize(int bitSize) {
        this.bitSize = bitSize;
    }

    public void setOtherSize(int otherSize) {
        this.otherSize = otherSize;
    }
}

