/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.metadata.clr;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.CustomRouteMap;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.DataEntityCacheType;
import kd.bos.dataentity.metadata.DataEntityTypeFlag;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.CollectionProperty;
import kd.bos.dataentity.metadata.clr.ComplexProperty;
import kd.bos.dataentity.metadata.clr.DataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.clr.IGetDataEntityStateHandler;
import kd.bos.dataentity.metadata.clr.SimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.beanutils.PropertyUtils;

@SdkPublic
public final class DataEntityType
implements IDataEntityType {
    private boolean loaded = false;
    IDataEntityType parent;
    private Class<?> type;
    private String name;
    private LocaleString displayName;
    private String tableName;
    private boolean isDbIgnore;
    private IGetDataEntityStateHandler getDataEntityStateHandler;
    private DataEntityCacheType cacheType = DataEntityCacheType.Share;
    private DataEntityPropertyCollection properties;
    private ISimpleProperty primaryKey;
    private DataEntityTypeFlag flag = DataEntityTypeFlag.forValue(0);
    private List<ISimpleProperty> sortProperties;
    private String dbRouteKey;
    private transient Object dataEntityReferenceSchema;
    private static Map<Class<?>, DataEntityType> _dtCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<?>, Object> lockMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDataEntityType getDataEntityType(Class<?> type) {
        if (type == null) {
            throw new ORMDesignException("??????", ResManager.loadKDString("\u6839\u636eType\u7c7b\u578b\u83b7\u53d6\u5b9e\u4f53\u7c7b\u578bDataEntityType\u5931\u8d25\uff0cType\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", "DataEntityType_0", "bos-dataentity", new Object[0]));
        }
        DataEntityType value = _dtCache.get(type);
        if (value != null && value.isLoaded()) {
            return value;
        }
        Object lockObj = null;
        Object object = lockMap;
        synchronized (object) {
            lockObj = lockMap.computeIfAbsent(type, k -> new Object());
        }
        object = lockObj;
        synchronized (object) {
            value = _dtCache.get(type);
            if (value == null) {
                value = new DataEntityType(type);
                _dtCache.put(type, value);
                value.initialize();
                value.setLoaded(true);
            }
            lockMap.remove(type);
        }
        return value;
    }

    private void setLoaded(boolean b) {
        this.loaded = true;
    }

    private boolean isLoaded() {
        return this.loaded;
    }

    public DataEntityType(Class<?> type) {
        this.type = type;
    }

    public Class<?> getDataEntityClass() {
        return this.type;
    }

    private void initialize() {
        this.flag = this.GetDataEntityTypeFlag();
        DataEntityTypeAttribute typeAtt = this.type.getAnnotation(DataEntityTypeAttribute.class);
        this.name = typeAtt != null && !typeAtt.name().isEmpty() ? typeAtt.name() : this.type.getSimpleName();
        if (typeAtt != null && !typeAtt.displayName().isEmpty()) {
            this.displayName = new LocaleString(typeAtt.displayName());
        }
        if (typeAtt != null && !typeAtt.tableName().isEmpty()) {
            this.tableName = typeAtt.tableName();
        }
        if (typeAtt != null) {
            this.isDbIgnore = typeAtt.isDbIgnore();
            this.dbRouteKey = typeAtt.dbRouteKey();
        }
        if (this.flag == DataEntityTypeFlag.Primitive) {
            this.properties = new DataEntityPropertyCollection(new ArrayList<IDataEntityProperty>(0), this, false);
        } else {
            PropertyDescriptor[] propertyInfos = PropertyUtils.getPropertyDescriptors(this.type);
            ArrayList<IDataEntityProperty> list = new ArrayList<IDataEntityProperty>(propertyInfos.length);
            int ordinal = 0;
            for (PropertyDescriptor pitem : propertyInfos) {
                DataEntityProperty property;
                Method readMethod = pitem.getReadMethod();
                if (readMethod == null) continue;
                if (readMethod.isAnnotationPresent(SimplePropertyAttribute.class)) {
                    if ((property = new SimpleProperty(pitem, ordinal++)).isPrimaryKey()) {
                        this.primaryKey = property;
                    }
                    property.parent = this;
                    list.add(property);
                    continue;
                }
                if (readMethod.isAnnotationPresent(ComplexPropertyAttribute.class)) {
                    property = new ComplexProperty(pitem, ordinal++);
                    property.parent = this;
                    list.add(property);
                    continue;
                }
                if (!readMethod.isAnnotationPresent(CollectionPropertyAttribute.class)) continue;
                CollectionProperty cproperty = new CollectionProperty(pitem, ordinal++);
                cproperty.parent = this;
                if (cproperty.getItemType() instanceof DataEntityType) {
                    ((DataEntityType)cproperty.getItemType()).parent = this;
                }
                list.add(cproperty);
            }
            list.trimToSize();
            this.properties = new DataEntityPropertyCollection(list, this, false);
        }
    }

    @Override
    public Object createInstance() {
        try {
            return this.type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OrmException("DataEntityType.CreateInstance", e.getMessage(), e);
        }
    }

    @Override
    public DataEntityPropertyCollection getProperties() {
        return this.properties;
    }

    @Override
    public ISimpleProperty getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public DataEntityTypeFlag getFlag() {
        return this.flag;
    }

    @Override
    public DataEntityCacheType getCacheType() {
        return this.cacheType;
    }

    @SdkInternal
    public void setCacheType(DataEntityCacheType value) {
        this.cacheType = value;
    }

    private DataEntityTypeFlag GetDataEntityTypeFlag() {
        if (this.type.isPrimitive() || this.type.isEnum()) {
            return DataEntityTypeFlag.Primitive;
        }
        if (Modifier.isAbstract(this.type.getModifiers())) {
            return DataEntityTypeFlag.Abstract;
        }
        if (Modifier.isFinal(this.type.getModifiers())) {
            return DataEntityTypeFlag.Final;
        }
        if (this.type.isInterface()) {
            return DataEntityTypeFlag.Interface;
        }
        return DataEntityTypeFlag.Class;
    }

    @Override
    public boolean isDirty(Object dataEntity) {
        return this.getDataEntityState(dataEntity).getDataEntityDirty();
    }

    @SdkInternal
    public DataEntityState getDataEntityState(Object dataEntity) {
        this.createDataEntityStateHandler();
        return this.getDataEntityStateHandler.apply(dataEntity);
    }

    private synchronized void createDataEntityStateHandler() {
        if (this.getDataEntityStateHandler == null) {
            this.getDataEntityStateHandler = DataEntityType.createGetDataEntityStateHandler(this);
        }
    }

    @Override
    public void setFromDatabase(Object dataEntity) {
        this.getDataEntityState(dataEntity).setFromDatabase(true);
    }

    @Override
    public void setFromDatabase(Object dataEntity, boolean clearDirty) {
        this.getDataEntityState(dataEntity).setFromDatabase(true, clearDirty);
    }

    private static IGetDataEntityStateHandler createGetDataEntityStateHandler(final DataEntityType dt) {
        PropertyDescriptor[] propertyInfos;
        Class<?> type = dt.getDataEntityClass();
        PropertyDescriptor p = null;
        for (PropertyDescriptor propertyDescriptor : propertyInfos = PropertyUtils.getPropertyDescriptors(type)) {
            if (!propertyDescriptor.getName().equals("dataEntityState")) continue;
            p = propertyDescriptor;
            break;
        }
        if (p != null) {
            final DataEntityProperty p2 = new DataEntityProperty(p, -1);
            return new IGetDataEntityStateHandler(){

                @Override
                public DataEntityState apply(Object t) {
                    return (DataEntityState)p2.getValue(t);
                }
            };
        }
        return new IGetDataEntityStateHandler(){

            @Override
            public DataEntityState apply(Object t) {
                return new AlwaysDirtyDataEntityState(dt);
            }
        };
    }

    @Override
    public final List<IDataEntityProperty> getDirtyProperties(Object dataEntity) {
        return this.getDataEntityState(dataEntity).GetDirtyProperties();
    }

    @Override
    public final List<IDataEntityProperty> getDirtyProperties(Object dataEntity, boolean includehasDefualt) {
        return this.getDataEntityState(dataEntity).GetDirtyProperties(includehasDefualt);
    }

    @Override
    public final void setDirty(Object dataEntity, boolean newValue) {
        this.getDataEntityState(dataEntity).setDirty(newValue);
    }

    @Override
    public final PkSnapshotSet getPkSnapshot(Object dataEntity) {
        return this.getDataEntityState(dataEntity).getPkSnapshotSet();
    }

    @Override
    public final void setPkSnapshot(Object dataEntity, PkSnapshotSet pkSnapshotSet) {
        this.getDataEntityState(dataEntity).setPkSnapshotSet(pkSnapshotSet);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocaleString getDisplayName() {
        if (this.displayName == null) {
            return new LocaleString(this.getName());
        }
        return this.displayName;
    }

    public void setDisplayName(LocaleString name) {
        this.displayName = name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getAlias() {
        return this.tableName;
    }

    @Override
    public void setAlias(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public IDataEntityType getParent() {
        return this.parent;
    }

    @Override
    public Object getParent(Object currentObject) {
        return null;
    }

    @Override
    public boolean isDbIgnore() {
        return this.isDbIgnore;
    }

    @SdkInternal
    public void setDbIgnore(boolean value) {
        this.isDbIgnore = value;
    }

    @Override
    public List<ISimpleProperty> getSortProperties() {
        if (this.sortProperties == null) {
            this.sortProperties = new ArrayList<ISimpleProperty>();
        }
        return this.sortProperties;
    }

    @Override
    public final String getDBRouteKey() {
        String customDBRouteKey = CustomRouteMap.getDBRouteKey((String)this.name);
        return customDBRouteKey == null ? this.dbRouteKey : customDBRouteKey;
    }

    @Override
    public boolean isEmpty(Object dataEntity) {
        if (dataEntity == null) {
            return true;
        }
        for (IDataEntityProperty prop : this.getProperties()) {
            if (prop.isEmpty(dataEntity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<IDataEntityProperty> getJsonSerializerProperties() {
        return this.getProperties();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Set<String> getFullIndexFields() {
        return new HashSet<String>();
    }

    @Override
    public boolean isFullIndexDataSynced() {
        return false;
    }

    @Override
    public Object createInstance(boolean isQueryObj) {
        return this.createInstance();
    }

    @Override
    public Object getDataEntityReferenceSchema() {
        return this.dataEntityReferenceSchema;
    }

    @Override
    public void setDataEntityReferenceSchema(Object dataEntityReferenceSchema) {
        this.dataEntityReferenceSchema = dataEntityReferenceSchema;
    }

    private static final class AlwaysDirtyDataEntityState
    extends DataEntityState {
        private DataEntityType dt;

        public AlwaysDirtyDataEntityState(DataEntityType dt) {
            this.dt = dt;
        }

        @Override
        public boolean getDataEntityDirty() {
            return true;
        }

        @Override
        public List<IDataEntityProperty> GetDirtyProperties() {
            ArrayList<IDataEntityProperty> properties = new ArrayList<IDataEntityProperty>();
            properties.addAll(this.dt.getProperties());
            return properties;
        }

        @Override
        public List<IDataEntityProperty> GetDirtyProperties(boolean includehasDefualt) {
            ArrayList<IDataEntityProperty> properties = new ArrayList<IDataEntityProperty>();
            properties.addAll(this.dt.getProperties());
            return properties;
        }

        @Override
        public void setPropertyChanged(PropertyChangeEvent e) {
        }

        @Override
        public void setDirty(boolean newValue) {
        }

        @Override
        public long[] getDirtyFlags() {
            return new long[0];
        }

        @Override
        public void setDirtyFlags(long[] values) {
        }

        @Override
        public void setDirty(ISimpleProperty prop, boolean newValue) {
        }
    }
}

