/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.metadata.clr;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.PropertyDescriptorUtils;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class SimpleProperty
extends DataEntityProperty
implements ISimpleProperty {
    private static final Log logger = LogFactory.getLog(SimpleProperty.class);
    private boolean shouldSerializeQueried;
    private boolean defaultValueQueried;
    private boolean primaryKey;
    private String alias;
    private int dbType;
    private boolean encrypt;
    private boolean enableNull;
    private String tableGroup;
    private Method shouldSerializeMethod;
    private Object _defaultValue = _noValue;
    private static Object _noValue = new Object();
    static final Set<Class<?>> numberTypes = new HashSet<Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(Byte.TYPE);
            this.add(Short.TYPE);
            this.add(Integer.TYPE);
            this.add(Long.TYPE);
            this.add(Double.TYPE);
            this.add(Float.TYPE);
        }
    };

    public SimpleProperty(PropertyDescriptor propertyInfo, int ordinal) {
        super(propertyInfo, ordinal);
        SimplePropertyAttribute spAtt = this.readMethod.getAnnotation(SimplePropertyAttribute.class);
        this.name = !spAtt.name().isEmpty() ? spAtt.name() : propertyInfo.getReadMethod().getName().substring(3);
        if (!spAtt.displayName().isEmpty()) {
            this.displayName = new LocaleString(spAtt.displayName());
        }
        this.primaryKey = spAtt.isPrimaryKey();
        this.alias = spAtt.alias();
        this.dbType = spAtt.dbType();
        this.setDbIgnore(spAtt.isDbIgnore());
        this.encrypt = spAtt.isEncrypt();
        this.tableGroup = spAtt.tableGroup();
        this.enableNull = spAtt.isEnableNull();
    }

    @Override
    public boolean isLocalizable() {
        return false;
    }

    @Override
    public void resetValue(Object dataEntity) {
        Object defValue;
        if (!this.getReadOnly() && (defValue = this.getDefaultValue(dataEntity)) != _noValue) {
            this.setValue(dataEntity, defValue);
        }
    }

    @Override
    public boolean shouldSerializeValue(Object dataEntity) {
        Object defaultValue;
        if (this.getShouldSerializeMethod() != null) {
            try {
                if (this.getDefaultValue(dataEntity) != _noValue) {
                    return (Boolean)this.shouldSerializeMethod.invoke(dataEntity, new Object[0]);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if ((defaultValue = this.getDefaultValue(dataEntity)) != _noValue) {
            return !ObjectUtils.nullSafeEquals(defaultValue, this.getValue(dataEntity));
        }
        return true;
    }

    private Object getDefaultValue(Object dataEntity) {
        if (!this.defaultValueQueried) {
            RefObject<Object> tempRef__defaultValue = new RefObject<Object>(this._defaultValue);
            boolean tempVar = PropertyDescriptorUtils.tryGetDefaultValue(this.readMethod, tempRef__defaultValue);
            this._defaultValue = tempRef__defaultValue.argvalue;
            if (!tempVar) {
                this._defaultValue = _noValue;
            }
            this.defaultValueQueried = true;
        }
        return this._defaultValue;
    }

    private Method getShouldSerializeMethod() {
        if (!this.shouldSerializeQueried) {
            this.shouldSerializeMethod = PropertyDescriptorUtils.getShouldSerializeMethod(this.readMethod.getDeclaringClass(), this.getName());
            this.shouldSerializeQueried = true;
        }
        return this.shouldSerializeMethod;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @SdkInternal
    public void setAlias(String value) {
        this.alias = value;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    @SdkInternal
    public void setPrimaryKey(boolean value) {
        this.primaryKey = value;
    }

    @Override
    public int getDbType() {
        return this.dbType;
    }

    @SdkInternal
    public void setDbType(int value) {
        this.dbType = value;
    }

    @Override
    public boolean isEncrypt() {
        return this.encrypt;
    }

    @SdkInternal
    public void setEncrypt(boolean value) {
        this.encrypt = value;
    }

    @Override
    public String getTableGroup() {
        return this.tableGroup;
    }

    public void setTableGroup(String value) {
        this.tableGroup = value;
    }

    @Override
    public boolean isEmpty(Object dataEntity) {
        Object v = this.getValue(dataEntity);
        return SimpleProperty.isEmptyValue(v, this.getPropertyType());
    }

    @SdkInternal
    public static boolean isEmptyValue(Object v, Class<?> cls) {
        if (v == null) {
            return true;
        }
        if (String.class.isAssignableFrom(cls)) {
            return StringUtils.isEmpty((String)((String)v));
        }
        if (numberTypes.contains(cls) || Number.class.isAssignableFrom(cls)) {
            return SimpleProperty.isEmptyNumber((Number)v);
        }
        if (java.util.Date.class.isAssignableFrom(cls)) {
            return v == null || v.equals(new Date(0L));
        }
        throw new OrmException("####", "not support!!!");
    }

    static boolean isEmptyNumber(Number v) {
        if (v == null) {
            return true;
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        String pattern = "#.#";
        DecimalFormat decimalFormat = new DecimalFormat(pattern, symbols);
        decimalFormat.setParseBigDecimal(true);
        try {
            BigDecimal bigDecimal = (BigDecimal)decimalFormat.parse(v.toString());
            return bigDecimal.equals(new BigDecimal(0));
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    public String toString() {
        return this.name + this.getClass().getSimpleName();
    }

    @Override
    public void setDirty(Object dataEntity, boolean newValue) {
    }

    @Override
    @SimplePropertyAttribute(name="EnableNull")
    public boolean isEnableNull() {
        return this.enableNull;
    }

    @SimplePropertyAttribute(name="EnableNull")
    public void setEnableNull(boolean value) {
        this.enableNull = value;
    }
}

