/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.metadata.database;

import kd.bos.dataentity.metadata.database.DbMetadataCollection;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.resource.ResManager;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DbMetadataColumnCollection
extends DbMetadataCollection<DbMetadataColumn> {
    private static final long serialVersionUID = 8679040132327949049L;
    private DbMetadataTable _tableSchema;

    public DbMetadataColumnCollection(DbMetadataTable tableSchema) {
        if (tableSchema == null) {
            throw new IllegalArgumentException("tableSchema");
        }
        this._tableSchema = tableSchema;
    }

    private void ResetColumnIndex(int start) {
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i < this.size(); ++i) {
            ((DbMetadataColumn)this.get(i)).setColumnIndex(i);
        }
    }

    @Override
    public boolean add(DbMetadataColumn item) {
        this.add(0, item);
        return true;
    }

    @Override
    public void add(int index, DbMetadataColumn item) {
        if (item == null) {
            throw new IllegalArgumentException("item");
        }
        if (item.getTable() != null) {
            if (item.getTable() == this._tableSchema) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString("\u5217%1$s\u5df2\u7ecf\u6dfb\u52a0\u5230\u5f53\u524d\u8868%2$s\uff0c\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0\u3002", "DbMetadataColumnCollection_0", "bos-dataentity", new Object[0]), item.getName(), this._tableSchema.getName()));
            }
            item.getTable().getColumns().remove(item);
        }
        super.add(index, item);
        item.setTable(this._tableSchema);
        this.ResetColumnIndex(index);
    }

    @Override
    public DbMetadataColumn remove(int index) {
        DbMetadataColumn removeItem = (DbMetadataColumn)this.get(index);
        DbMetadataColumn col = (DbMetadataColumn)super.remove(index);
        removeItem.setTable(null);
        this.ResetColumnIndex(index);
        return col;
    }

    @Override
    public DbMetadataColumn set(int index, DbMetadataColumn item) {
        if (item.getTable() != null) {
            if (item.getTable() == this._tableSchema) {
                return null;
            }
            item.getTable().getColumns().remove(item);
        }
        DbMetadataColumn removeItem = (DbMetadataColumn)this.get(index);
        removeItem.setTable(null);
        DbMetadataColumn col = super.set(index, item);
        item.setTable(this._tableSchema);
        item.setColumnIndex(index);
        return col;
    }

    @Override
    public void clear() {
        for (DbMetadataColumn item : this) {
            item.setTable(null);
        }
        super.clear();
    }
}

